/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.beans.ConstructorProperties;
import java.util.Map;
import kikaha.urouting.api.ExceptionHandler;
import kikaha.urouting.api.Response;

public class RoutingMethodExceptionHandler {
    final Map<Class<?>, ExceptionHandler<?>> handlers;
    final ExceptionHandler<Throwable> fallbackHandler;

    public Response handle(Throwable throwable) {
        ExceptionHandler<Throwable> exceptionHandler = this.retrieveHandlerFor(throwable.getClass());
        if (exceptionHandler == null) {
            exceptionHandler = this.fallbackHandler;
        }
        return exceptionHandler.handle(throwable);
    }

    private ExceptionHandler<Throwable> retrieveHandlerFor(Class<?> clazz) {
        ExceptionHandler<?> exceptionHandler = null;
        while (!Exception.class.equals(clazz) && exceptionHandler == null) {
            exceptionHandler = this.handlers.get(clazz);
            clazz = clazz.getSuperclass();
        }
        return exceptionHandler;
    }

    @ConstructorProperties(value={"handlers", "fallbackHandler"})
    public RoutingMethodExceptionHandler(Map<Class<?>, ExceptionHandler<?>> map, ExceptionHandler<Throwable> exceptionHandler) {
        this.handlers = map;
        this.fallbackHandler = exceptionHandler;
    }
}

