/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.config.Config;
import kikaha.core.cdi.CDI;
import kikaha.urouting.Reflection;
import kikaha.urouting.RoutingMethodExceptionHandler;
import kikaha.urouting.api.ExceptionHandler;

@Singleton
public class RoutingMethodExceptionHandlerLoader {
    @Inject
    @Typed(value={ExceptionHandler.class})
    Iterable<ExceptionHandler> availableHandlers;
    @Inject
    Config kikahaConf;
    @Inject
    CDI provider;
    RoutingMethodExceptionHandler exceptionHandler;
    ExceptionHandler<Throwable> fallbackHandler;

    @PostConstruct
    public void loadData() {
        this.fallbackHandler = this.loadFallbackHandler();
        HashMap<Class<?>, ExceptionHandler<?>> hashMap = this.loadHandlers();
        this.exceptionHandler = new RoutingMethodExceptionHandler(hashMap, this.fallbackHandler);
    }

    private ExceptionHandler<Throwable> loadFallbackHandler() {
        Class clazz = this.kikahaConf.getClass("server.urouting.exception-handler");
        return (ExceptionHandler)this.provider.load(clazz);
    }

    private HashMap<Class<?>, ExceptionHandler<?>> loadHandlers() {
        HashMap hashMap = new HashMap();
        for (ExceptionHandler exceptionHandler : this.availableHandlers) {
            Class clazz = this.getGenericClass(exceptionHandler);
            hashMap.put(clazz, exceptionHandler);
        }
        return hashMap;
    }

    private <T extends Throwable> Class<T> getGenericClass(ExceptionHandler<T> exceptionHandler) {
        return Reflection.getFirstGenericTypeFrom(exceptionHandler, ExceptionHandler.class);
    }

    @Produces
    public RoutingMethodExceptionHandler produceExceptionHandler() {
        return this.exceptionHandler;
    }
}

