/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.PathTemplateMatch;
import java.io.IOException;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.config.Config;
import kikaha.urouting.SerializerAndUnserializerProvider;
import kikaha.urouting.api.ContextProducer;
import kikaha.urouting.api.ContextProducerFactory;
import kikaha.urouting.api.ConversionException;
import kikaha.urouting.api.ConverterFactory;
import kikaha.urouting.api.RoutingException;
import kikaha.urouting.api.Unserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingMethodParameterReader {
    private static final Logger log = LoggerFactory.getLogger(RoutingMethodParameterReader.class);
    @Inject
    Config kikahaConf;
    @Inject
    ConverterFactory converterFactory;
    @Inject
    ContextProducerFactory contextProducerFactory;
    @Inject
    SerializerAndUnserializerProvider serializerAndUnserializerProvider;
    String defaultEncoding;
    String defaultContentType;
    Function<HeaderMap, String> contentTypeSupplier;

    @PostConstruct
    public void readConfig() {
        this.defaultEncoding = this.kikahaConf.getString("server.urouting.default-encoding");
        this.defaultContentType = this.kikahaConf.getString("server.urouting.default-content-type");
        String string = this.kikahaConf.getString("server.urouting.content-type-priority");
        this.contentTypeSupplier = ContentTypePriority.from(string).equals((Object)ContentTypePriority.CONFIG) ? this::getDefaultContentType : this::getContentFromRequest;
        log.info("Micro Routing API");
        log.info("  default-encoding: " + this.defaultEncoding);
        log.info("  default-content-type: " + this.defaultContentType);
        log.info("  content-type-priority: " + string);
    }

    String getContentFromRequest(HeaderMap headerMap) {
        String string = headerMap.getFirst("Content-Type");
        return headerMap == null ? this.getDefaultContentType() : string;
    }

    String getDefaultContentType(HeaderMap headerMap) {
        return this.getDefaultContentType();
    }

    public <T> T getCookieParam(HttpServerExchange httpServerExchange, String string, Class<T> clazz) throws ConversionException, InstantiationException, IllegalAccessException {
        Cookie cookie = (Cookie)httpServerExchange.getRequestCookies().get(string);
        if (cookie == null) {
            return null;
        }
        String string2 = cookie.getValue();
        return this.converterFactory.getConverterFor(clazz).convert(string2);
    }

    public <T> T getQueryParam(HttpServerExchange httpServerExchange, String string, Class<T> clazz) throws ConversionException, InstantiationException, IllegalAccessException {
        Queue queue = (Queue)httpServerExchange.getQueryParameters().get(string);
        if (queue == null) {
            return null;
        }
        String string2 = (String)queue.peek();
        return this.converterFactory.getConverterFor(clazz).convert(string2);
    }

    public <T> T getFormParam(HttpServerExchange httpServerExchange, String string, Class<T> clazz) throws ConversionException, InstantiationException, IllegalAccessException {
        FormData formData = (FormData)httpServerExchange.getAttachment(FormDataParser.FORM_DATA);
        if (formData == null) {
            throw new IllegalAccessException("Could not found the FormData.");
        }
        FormData.FormValue formValue = formData.getFirst(string);
        if (formValue == null) {
            return null;
        }
        if (formValue.isFile()) {
            return (T)formValue.getPath().toFile();
        }
        String string2 = formValue.getValue();
        return this.converterFactory.getConverterFor(clazz).convert(string2);
    }

    public <T> T getHeaderParam(HttpServerExchange httpServerExchange, String string, Class<T> clazz) throws ConversionException, InstantiationException, IllegalAccessException {
        String string2 = httpServerExchange.getRequestHeaders().getFirst(string);
        if (string2 == null) {
            return null;
        }
        return this.converterFactory.getConverterFor(clazz).convert(string2);
    }

    public <T> T getPathParam(HttpServerExchange httpServerExchange, String string, Class<T> clazz) throws ConversionException, InstantiationException, IllegalAccessException {
        String string2 = this.getPathParams(httpServerExchange).get(string);
        return this.converterFactory.getConverterFor(clazz).convert(string2);
    }

    public Map<String, String> getPathParams(HttpServerExchange httpServerExchange) {
        PathTemplateMatch pathTemplateMatch = (PathTemplateMatch)httpServerExchange.getAttachment(PathTemplateMatch.ATTACHMENT_KEY);
        return pathTemplateMatch.getParameters();
    }

    public <T> T getBody(HttpServerExchange httpServerExchange, Class<T> clazz, byte[] byArray) throws IOException {
        return this.getBody(httpServerExchange, clazz, byArray, this.getDefaultContentType());
    }

    public <T> T getBody(HttpServerExchange httpServerExchange, Class<T> clazz, byte[] byArray, String string) throws IOException {
        HeaderMap headerMap = httpServerExchange.getRequestHeaders();
        String string2 = headerMap.getFirst("Content-Encoding");
        if (string2 == null) {
            string2 = this.getDefaultEncoding();
        }
        String string3 = this.contentTypeSupplier.apply(headerMap);
        return this.unserializeReceivedBodyStream(httpServerExchange, clazz, byArray, string2, string3);
    }

    private <T> T unserializeReceivedBodyStream(HttpServerExchange httpServerExchange, Class<T> clazz, byte[] byArray, String string, String string2) throws IOException {
        if (!httpServerExchange.isBlocking()) {
            httpServerExchange.startBlocking();
        }
        Unserializer unserializer = this.serializerAndUnserializerProvider.getUnserializerFor(string2);
        return unserializer.unserialize(httpServerExchange, clazz, byArray, string);
    }

    public <T> T getData(HttpServerExchange httpServerExchange, Class<T> clazz) throws RoutingException {
        ContextProducer<T> contextProducer = this.contextProducerFactory.producerFor(clazz);
        if (contextProducer != null) {
            return contextProducer.produce(httpServerExchange);
        }
        throw new RoutingException("No context provider for " + clazz.getCanonicalName());
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    static enum ContentTypePriority {
        CONFIG,
        REQUEST;


        static ContentTypePriority from(String string) {
            try {
                if (string != null && !string.isEmpty()) {
                    return ContentTypePriority.valueOf(string);
                }
            }
            catch (Throwable throwable) {
                log.error("Can't identify Content-Type priority", throwable);
            }
            return REQUEST;
        }
    }
}

