/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.config.Config;
import kikaha.urouting.SerializerAndUnserializerProvider;
import kikaha.urouting.api.Header;
import kikaha.urouting.api.Response;
import kikaha.urouting.api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RoutingMethodResponseWriter {
    private static final Logger log = LoggerFactory.getLogger(RoutingMethodResponseWriter.class);
    @Inject
    Config kikahaConf;
    @Inject
    SerializerAndUnserializerProvider serializerAndUnserializerProvider;
    String defaultEncoding;
    String defaultContentType;

    @PostConstruct
    public void readConfig() {
        this.defaultEncoding = this.kikahaConf.getString("server.urouting.default-encoding");
        this.defaultContentType = this.kikahaConf.getString("server.urouting.default-content-type");
    }

    public void write(HttpServerExchange httpServerExchange) {
        this.sendStatusCode(httpServerExchange, 204);
        httpServerExchange.endExchange();
    }

    public void write(HttpServerExchange httpServerExchange, Response response) throws IOException {
        this.write(httpServerExchange, this.getDefaultContentType(), response);
    }

    public void write(HttpServerExchange httpServerExchange, Object object) throws IOException {
        this.write(httpServerExchange, this.getDefaultContentType(), object);
    }

    public void write(HttpServerExchange httpServerExchange, String string, Object object) throws IOException {
        this.sendStatusCode(httpServerExchange, 200);
        this.sendContentTypeHeader(httpServerExchange, string);
        this.sendBodyResponse(httpServerExchange, string, this.getDefaultEncoding(), object);
    }

    public void write(HttpServerExchange httpServerExchange, String string, Response response) throws IOException {
        String string2 = response.contentType() != null ? response.contentType() : string;
        this.sendStatusCode(httpServerExchange, response.statusCode());
        this.sendHeaders(httpServerExchange, response);
        this.sendContentTypeHeader(httpServerExchange, string2);
        this.sendBodyResponse(httpServerExchange, string2, response.encoding(), response.entity());
    }

    HttpServerExchange sendStatusCode(HttpServerExchange httpServerExchange, Integer n) {
        httpServerExchange.setStatusCode(n.intValue());
        return httpServerExchange;
    }

    void sendBodyResponse(HttpServerExchange httpServerExchange, String string, String string2, Object object) throws IOException {
        Serializer serializer = this.getSerializer(string);
        serializer.serialize(object, httpServerExchange, string2);
    }

    private Serializer getSerializer(String string) throws IOException {
        return this.serializerAndUnserializerProvider.getSerializerFor(string);
    }

    private void sendHeaders(HttpServerExchange httpServerExchange, Response response) {
        HeaderMap headerMap = httpServerExchange.getResponseHeaders();
        if (response.headers() != null) {
            for (Header header : response.headers()) {
                for (String string : header.values()) {
                    this.sendHeader(headerMap, header, string);
                }
            }
        }
    }

    void sendHeader(HeaderMap headerMap, Header header, String string) {
        headerMap.add(header.name(), string);
    }

    void sendContentTypeHeader(HttpServerExchange httpServerExchange, String string) {
        HeaderMap headerMap = httpServerExchange.getResponseHeaders();
        if (!headerMap.contains("Content-Type") && string != null) {
            headerMap.add(Headers.CONTENT_TYPE, string);
        }
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getDefaultContentType() {
        return this.defaultContentType;
    }
}

