/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import kikaha.core.url.URL;
import kikaha.urouting.UnsupportedMediaTypeException;
import kikaha.urouting.api.Serializer;
import kikaha.urouting.api.Unserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerAndUnserializerProvider {
    private static final Logger log = LoggerFactory.getLogger(SerializerAndUnserializerProvider.class);
    final Map<String, Serializer> serializerByContentType;
    final Map<String, Unserializer> unserializerByContentType;

    public Serializer getSerializerFor(String string) throws IOException {
        Serializer serializer = this.serializerByContentType.get(string);
        if (serializer == null) {
            UnsupportedMediaTypeException unsupportedMediaTypeException = new UnsupportedMediaTypeException(string);
            log.error("Could not found a serializer for " + string, (Throwable)unsupportedMediaTypeException);
            throw unsupportedMediaTypeException;
        }
        return serializer;
    }

    public Unserializer getUnserializerFor(String string) throws IOException {
        Unserializer unserializer = this.unserializerByContentType.get(string = (String)URL.fixContentType((String)string, null).getFirst());
        if (unserializer == null) {
            UnsupportedMediaTypeException unsupportedMediaTypeException = new UnsupportedMediaTypeException(string);
            log.error("Could not found an unserializer for " + string, (Throwable)unsupportedMediaTypeException);
            throw unsupportedMediaTypeException;
        }
        return unserializer;
    }

    @ConstructorProperties(value={"serializerByContentType", "unserializerByContentType"})
    public SerializerAndUnserializerProvider(Map<String, Serializer> map, Map<String, Unserializer> map2) {
        this.serializerByContentType = map;
        this.unserializerByContentType = map2;
    }
}

