/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.core.modules.http.ContentType;
import kikaha.urouting.SerializerAndUnserializerProvider;
import kikaha.urouting.api.Serializer;
import kikaha.urouting.api.Unserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SerializerAndUnserializerProviderLoader {
    private static final Logger log = LoggerFactory.getLogger(SerializerAndUnserializerProviderLoader.class);
    @Inject
    @Typed(value={Serializer.class})
    Iterable<Serializer> availableSerializers;
    @Inject
    @Typed(value={Unserializer.class})
    Iterable<Unserializer> availableUnserializers;
    SerializerAndUnserializerProvider serializerAndUnserializerProvider;

    @PostConstruct
    public void onStartup() {
        Map<String, Serializer> map = this.loadAllSerializers();
        log.trace("Found Content Type serializers: " + map);
        Map<String, Unserializer> map2 = this.loadAllUnserializers();
        log.trace("Found Content Type unserializers: " + map2);
        this.serializerAndUnserializerProvider = new SerializerAndUnserializerProvider(map, map2);
    }

    @Produces
    public SerializerAndUnserializerProvider produceSerializerAndUnserializerProvider() {
        return this.serializerAndUnserializerProvider;
    }

    private Map<String, Serializer> loadAllSerializers() {
        HashMap<String, Serializer> hashMap = new HashMap<String, Serializer>();
        for (Serializer serializer : this.availableSerializers) {
            hashMap.put(this.extractContentTypeFrom(serializer), serializer);
        }
        return hashMap;
    }

    private Map<String, Unserializer> loadAllUnserializers() {
        HashMap<String, Unserializer> hashMap = new HashMap<String, Unserializer>();
        for (Unserializer unserializer : this.availableUnserializers) {
            hashMap.put(this.extractContentTypeFrom(unserializer), unserializer);
        }
        return hashMap;
    }

    String extractContentTypeFrom(Object object) {
        Class<?> clazz = object.getClass();
        ContentType contentType = clazz.getAnnotation(ContentType.class);
        if (contentType != null) {
            return contentType.value();
        }
        throw new UnsupportedOperationException(clazz + " must be annotated with @" + ContentType.class.getSimpleName());
    }
}

