/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Deque;
import java.util.Map;
import kikaha.urouting.RoutingMethodExceptionHandler;
import kikaha.urouting.RoutingMethodParameterReader;
import kikaha.urouting.RoutingMethodResponseWriter;
import kikaha.urouting.api.ConversionException;
import kikaha.urouting.api.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleExchange {
    private static final Logger log = LoggerFactory.getLogger(SimpleExchange.class);
    final HttpServerExchange exchange;
    final RoutingMethodParameterReader parameterReader;
    final RoutingMethodResponseWriter responseWriter;
    final RoutingMethodExceptionHandler exceptionHandler;

    public String getHostAndPort() {
        return this.exchange.getHostAndPort();
    }

    public String getRequestScheme() {
        return this.exchange.getRequestScheme();
    }

    public HttpString getHttpMethod() {
        return this.exchange.getRequestMethod();
    }

    public String getRelativePath() {
        return this.exchange.getRelativePath();
    }

    public Map<String, Deque<String>> getQueryParameters() {
        return this.exchange.getQueryParameters();
    }

    public <T> T getQueryParameter(String string, Class<T> clazz) throws IOException {
        try {
            return this.parameterReader.getQueryParam(this.exchange, string, clazz);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IOException(reflectiveOperationException);
        }
    }

    public Map<String, String> getPathParameters() {
        return this.parameterReader.getPathParams(this.exchange);
    }

    public <T> T getPathParameter(String string, Class<T> clazz) throws IOException {
        try {
            return this.parameterReader.getPathParam(this.exchange, string, clazz);
        }
        catch (IllegalAccessException | InstantiationException | ConversionException exception) {
            throw new IOException(exception);
        }
    }

    public HeaderMap getHeaderParameters() {
        return this.exchange.getRequestHeaders();
    }

    public <T> T getHeaderParameter(String string, Class<T> clazz) throws IOException {
        try {
            return this.parameterReader.getHeaderParam(this.exchange, string, clazz);
        }
        catch (IllegalAccessException | InstantiationException | ConversionException exception) {
            throw new IOException(exception);
        }
    }

    public Map<String, Cookie> getCookieParameters() {
        return this.exchange.getRequestCookies();
    }

    public <T> T getCookieParameter(String string, Class<T> clazz) throws IOException {
        try {
            return this.parameterReader.getCookieParam(this.exchange, string, clazz);
        }
        catch (IllegalAccessException | InstantiationException | ConversionException exception) {
            throw new IOException(exception);
        }
    }

    public <T> T getRequestBody(Class<T> clazz, byte[] byArray) throws IOException {
        return this.getRequestBody(clazz, byArray, this.parameterReader.defaultContentType);
    }

    public <T> T getRequestBody(Class<T> clazz, byte[] byArray, String string) throws IOException {
        return this.parameterReader.getBody(this.exchange, clazz, byArray, string);
    }

    public void sendResponse(Response response) throws IOException {
        this.responseWriter.write(this.exchange, response);
    }

    public void sendResponse(Throwable throwable) throws IOException {
        this.sendResponse(this.exceptionHandler.handle(throwable));
    }

    public void sendResponse(Object object) throws IOException {
        this.sendResponse(object, this.responseWriter.defaultContentType);
    }

    public void sendResponse(Object object, String string) throws IOException {
        this.responseWriter.write(this.exchange, string, object);
    }

    public void endExchange() {
        this.exchange.endExchange();
    }

    public void receiveRequest(ContentReceiver<SimpleExchange, byte[]> contentReceiver) {
        this.exchange.getRequestReceiver().receiveFullBytes((httpServerExchange, byArray) -> {
            try {
                contentReceiver.accept(this, byArray);
            }
            catch (Throwable throwable) {
                this.handleFailure(this.exchange, throwable);
            }
        }, this::handleFailure);
    }

    private void handleFailure(HttpServerExchange httpServerExchange, Throwable throwable) {
        try {
            this.sendResponse(throwable);
        }
        catch (IOException iOException) {
            log.error("Could not handle exception. Reason: " + iOException.getMessage(), (Throwable)iOException);
            log.error("Original exception: " + throwable.getMessage(), throwable);
        }
    }

    @ConstructorProperties(value={"exchange", "parameterReader", "responseWriter", "exceptionHandler"})
    private SimpleExchange(HttpServerExchange httpServerExchange, RoutingMethodParameterReader routingMethodParameterReader, RoutingMethodResponseWriter routingMethodResponseWriter, RoutingMethodExceptionHandler routingMethodExceptionHandler) {
        this.exchange = httpServerExchange;
        this.parameterReader = routingMethodParameterReader;
        this.responseWriter = routingMethodResponseWriter;
        this.exceptionHandler = routingMethodExceptionHandler;
    }

    public static SimpleExchange wrap(HttpServerExchange httpServerExchange, RoutingMethodParameterReader routingMethodParameterReader, RoutingMethodResponseWriter routingMethodResponseWriter, RoutingMethodExceptionHandler routingMethodExceptionHandler) {
        return new SimpleExchange(httpServerExchange, routingMethodParameterReader, routingMethodResponseWriter, routingMethodExceptionHandler);
    }

    public static interface ContentReceiver<K, V> {
        public void accept(K var1, V var2) throws Throwable;
    }
}

