/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.api;

import io.undertow.server.HttpServerExchange;
import java.beans.ConstructorProperties;
import java.io.IOException;
import kikaha.urouting.RoutingMethodExceptionHandler;
import kikaha.urouting.RoutingMethodResponseWriter;
import kikaha.urouting.api.Response;
import kikaha.urouting.api.RoutingException;
import kikaha.urouting.api.WrappedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResponse {
    private static final Logger log = LoggerFactory.getLogger(AsyncResponse.class);
    final HttpServerExchange exchange;
    final RoutingMethodResponseWriter writer;
    final RoutingMethodExceptionHandler exceptionHandler;
    String contentType;

    public void write(Response response) {
        try {
            this.writeWithTheRightContentType(response);
        }
        catch (Throwable throwable) {
            this.handleFailure(throwable);
        }
    }

    void writeWithTheRightContentType(Response response) throws RoutingException, IOException {
        if (this.contentType != null) {
            response = new WrappedResponse(response).contentType(this.contentType);
        }
        this.writer.write(this.exchange, response);
    }

    void handleFailure(Throwable throwable) {
        log.error(throwable.getMessage(), throwable);
        try {
            this.writer.write(this.exchange, this.exceptionHandler.handle(throwable));
        }
        catch (Throwable throwable2) {
            log.error(throwable2.getMessage(), throwable2);
            this.exchange.endExchange();
        }
    }

    @ConstructorProperties(value={"exchange", "writer", "exceptionHandler", "contentType"})
    public AsyncResponse(HttpServerExchange httpServerExchange, RoutingMethodResponseWriter routingMethodResponseWriter, RoutingMethodExceptionHandler routingMethodExceptionHandler, String string) {
        this.exchange = httpServerExchange;
        this.writer = routingMethodResponseWriter;
        this.exceptionHandler = routingMethodExceptionHandler;
        this.contentType = string;
    }

    @ConstructorProperties(value={"exchange", "writer", "exceptionHandler"})
    public AsyncResponse(HttpServerExchange httpServerExchange, RoutingMethodResponseWriter routingMethodResponseWriter, RoutingMethodExceptionHandler routingMethodExceptionHandler) {
        this.exchange = httpServerExchange;
        this.writer = routingMethodResponseWriter;
        this.exceptionHandler = routingMethodExceptionHandler;
    }
}

