/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.api;

import java.beans.ConstructorProperties;
import java.util.Map;
import kikaha.urouting.api.AbstractConverter;
import kikaha.urouting.api.ConversionException;

public class ConverterFactory {
    final Map<String, AbstractConverter<?>> converters;

    public <T> T decode(String string, Class<T> clazz) throws ConversionException {
        try {
            if (string == null || String.class.equals(clazz)) {
                return (T)string;
            }
            AbstractConverter<T> abstractConverter = this.getConverterFor(clazz);
            return abstractConverter.convert(string);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new ConversionException(String.format("Can't convert '%s' to '%s'", string, clazz.getCanonicalName()), reflectiveOperationException);
        }
    }

    public <T> AbstractConverter<T> getConverterFor(Class<T> clazz) throws InstantiationException, IllegalAccessException, ConversionException {
        String string = clazz.getCanonicalName();
        AbstractConverter<?> abstractConverter = this.converters.get(string);
        if (abstractConverter == null) {
            throw new ConversionException("No converters defined to " + string);
        }
        return abstractConverter;
    }

    @ConstructorProperties(value={"converters"})
    public ConverterFactory(Map<String, AbstractConverter<?>> map) {
        this.converters = map;
    }
}

