/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.api;

import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.net.URI;
import java.util.List;
import kikaha.core.cdi.helpers.TinyList;
import kikaha.urouting.api.DefaultHeader;
import kikaha.urouting.api.Header;
import kikaha.urouting.api.MutableResponse;
import kikaha.urouting.api.Response;
import lombok.NonNull;

public class DefaultResponse
implements Response,
MutableResponse {
    int statusCode = 200;
    @NonNull
    Object entity = "";
    @NonNull
    String encoding = "UTF-8";
    @NonNull
    List<Header> headers = new TinyList();

    @Override
    public DefaultResponse headers(Iterable<Header> iterable) {
        this.headers = new TinyList();
        for (Header header : iterable) {
            this.headers.add(header);
        }
        return this;
    }

    @Override
    public DefaultResponse header(HttpString httpString, @NonNull String string) {
        if (string == null) {
            throw new NullPointerException("value");
        }
        Header header = this.header(httpString);
        if (header == null) {
            header = DefaultHeader.createHeader(httpString, string);
            this.headers.add(header);
        } else {
            header.add(string);
        }
        return this;
    }

    public static DefaultResponse response() {
        return new DefaultResponse();
    }

    public static DefaultResponse response(int n) {
        return new DefaultResponse().statusCode(n);
    }

    public static DefaultResponse ok() {
        return DefaultResponse.response().statusCode(200);
    }

    public static DefaultResponse ok(Object object) {
        return DefaultResponse.ok().entity(object);
    }

    public static DefaultResponse noContent() {
        return DefaultResponse.response().statusCode(204);
    }

    public static DefaultResponse created() {
        return DefaultResponse.response().statusCode(201);
    }

    public static DefaultResponse created(String string) {
        return DefaultResponse.response().statusCode(201).header(Headers.LOCATION, string);
    }

    public static DefaultResponse accepted() {
        return DefaultResponse.response().statusCode(202);
    }

    public static DefaultResponse movedPermanently() {
        return DefaultResponse.response().statusCode(301);
    }

    public static DefaultResponse notModified() {
        return DefaultResponse.response().statusCode(304);
    }

    public static DefaultResponse seeOther() {
        return DefaultResponse.response().statusCode(303);
    }

    public static DefaultResponse seeOther(String string) {
        return DefaultResponse.response().statusCode(303).header(Headers.LOCATION, string);
    }

    public static DefaultResponse temporaryRedirect(String string) {
        return DefaultResponse.response().statusCode(307).header(Headers.LOCATION, string);
    }

    public static DefaultResponse temporaryRedirect(URI uRI) {
        return DefaultResponse.temporaryRedirect(uRI.toString());
    }

    public static DefaultResponse permanentRedirect(String string) {
        return DefaultResponse.response().statusCode(308).header(Headers.LOCATION, string);
    }

    public static DefaultResponse permanentRedirect(URI uRI) {
        return DefaultResponse.permanentRedirect(uRI.toString());
    }

    public static DefaultResponse badRequest() {
        return DefaultResponse.response().statusCode(400);
    }

    public static DefaultResponse unauthorized() {
        return DefaultResponse.response().statusCode(401);
    }

    public static DefaultResponse forbiden() {
        return DefaultResponse.response().statusCode(403);
    }

    public static DefaultResponse notFound() {
        return DefaultResponse.response().statusCode(404);
    }

    public static DefaultResponse preconditionFailed() {
        return DefaultResponse.response().statusCode(412);
    }

    public static DefaultResponse serverError() {
        return DefaultResponse.response().statusCode(500);
    }

    public static DefaultResponse serverError(String string) {
        return DefaultResponse.response().statusCode(500).entity(string);
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @NonNull
    public Object entity() {
        return this.entity;
    }

    @Override
    @NonNull
    public String encoding() {
        return this.encoding;
    }

    @NonNull
    public List<Header> headers() {
        return this.headers;
    }

    public DefaultResponse statusCode(int n) {
        this.statusCode = n;
        return this;
    }

    @Override
    public DefaultResponse entity(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("entity");
        }
        this.entity = object;
        return this;
    }

    @Override
    public DefaultResponse encoding(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("encoding");
        }
        this.encoding = string;
        return this;
    }
}

