/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.apt;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.enterprise.inject.Typed;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import kikaha.apt.APT;
import kikaha.apt.AbstractAnnotatedMethodProcessor;
import kikaha.apt.GenerableClass;
import kikaha.apt.MethodParametersExtractor;
import kikaha.urouting.RoutingMethodData;
import kikaha.urouting.api.Consumes;
import kikaha.urouting.api.DELETE;
import kikaha.urouting.api.GET;
import kikaha.urouting.api.MultiPartFormData;
import kikaha.urouting.api.PATCH;
import kikaha.urouting.api.POST;
import kikaha.urouting.api.PUT;
import kikaha.urouting.apt.EmptyTypeMirror;
import kikaha.urouting.apt.MicroRoutingParameterParser;

@SupportedAnnotationTypes(value={"kikaha.urouting.api.*"})
public class MicroRoutingAnnotationProcessor
extends AbstractAnnotatedMethodProcessor {
    final MethodParametersExtractor parametersExtractor = new MicroRoutingParameterParser(this::extractParamFromNonAnnotatedParameter);
    final List<Class<? extends Annotation>> expectedMethodAnnotations = Arrays.asList(GET.class, POST.class, PUT.class, DELETE.class, PATCH.class, MultiPartFormData.class);
    final String templateName = "routing-method-class.mustache";

    public void generateMethod(ExecutableElement executableElement, RoundEnvironment roundEnvironment, Class<? extends Annotation> clazz) throws IOException {
        RoutingMethodData routingMethodData = this.toRoutingMethodData(executableElement, clazz);
        this.info("  \u0424 " + routingMethodData);
        this.generator.generate((GenerableClass)routingMethodData);
    }

    private RoutingMethodData toRoutingMethodData(ExecutableElement executableElement, Class<? extends Annotation> clazz) {
        String string = APT.asType((Element)executableElement.getEnclosingElement());
        String string2 = this.parametersExtractor.extractMethodParamsFrom(executableElement);
        boolean bl = clazz.equals(MultiPartFormData.class) || string2.contains("methodDataProvider.getFormParam");
        boolean bl2 = string2.contains("asyncResponse");
        String string3 = clazz.equals(MultiPartFormData.class) ? "POST" : clazz.getSimpleName();
        return MicroRoutingAnnotationProcessor.createRouteMethodData(executableElement, bl, string3, string, string2, bl2);
    }

    private static RoutingMethodData createRouteMethodData(ExecutableElement executableElement, boolean bl, String string, String string2, String string3, boolean bl2) {
        String string4 = APT.extractReturnTypeFrom((ExecutableElement)executableElement);
        boolean bl3 = string3.contains("methodDataProvider.getBody");
        if (string4 != null && bl2) {
            throw new UnsupportedOperationException("Invalid Routing Method '" + executableElement.asType().toString() + "'. Async methods should not have return type.");
        }
        return new RoutingMethodData(APT.extractTypeName((String)string2), APT.extractPackageName((String)string2), executableElement.getSimpleName().toString(), string3, string4, MicroRoutingParameterParser.extractResponseContentTypeFrom(executableElement), MicroRoutingParameterParser.extractHttpPathFrom(executableElement), string, MicroRoutingAnnotationProcessor.extractServiceInterfaceFrom(executableElement), bl3, bl, bl2);
    }

    private String extractParamFromNonAnnotatedParameter(ExecutableElement executableElement, VariableElement variableElement) {
        String string = MicroRoutingAnnotationProcessor.extractConsumingContentTypeFrom(executableElement);
        String string2 = APT.asType((Element)variableElement);
        if (string != null) {
            return String.format("methodDataProvider.getBody( exchange, %s.class, bodyData, \"%s\" )", string2, string);
        }
        return String.format("methodDataProvider.getBody( exchange, %s.class, bodyData )", string2);
    }

    static String extractConsumingContentTypeFrom(ExecutableElement executableElement) {
        Consumes consumes = executableElement.getAnnotation(Consumes.class);
        if (consumes == null) {
            consumes = executableElement.getEnclosingElement().getAnnotation(Consumes.class);
        }
        if (consumes != null) {
            return consumes.value();
        }
        return null;
    }

    static String extractServiceInterfaceFrom(ExecutableElement executableElement) {
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        String string = MicroRoutingAnnotationProcessor.getServiceInterfaceProviderClass(typeElement).toString();
        if (string.isEmpty()) {
            return typeElement.asType().toString();
        }
        return string;
    }

    static TypeMirror getServiceInterfaceProviderClass(TypeElement typeElement) {
        try {
            Typed typed = typeElement.getAnnotation(Typed.class);
            if (typed != null) {
                typed.value()[0].getCanonicalName();
            }
            return new EmptyTypeMirror();
        }
        catch (MirroredTypesException mirroredTypesException) {
            return mirroredTypesException.getTypeMirrors().get(0);
        }
    }

    public MethodParametersExtractor getParametersExtractor() {
        return this.parametersExtractor;
    }

    public List<Class<? extends Annotation>> getExpectedMethodAnnotations() {
        return this.expectedMethodAnnotations;
    }

    public String getTemplateName() {
        return this.templateName;
    }
}

