/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.apt;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import kikaha.apt.APT;
import kikaha.apt.ChainedRules;
import kikaha.apt.MethodParametersExtractor;
import kikaha.urouting.api.AsyncResponse;
import kikaha.urouting.api.Context;
import kikaha.urouting.api.CookieParam;
import kikaha.urouting.api.FormParam;
import kikaha.urouting.api.HeaderParam;
import kikaha.urouting.api.Path;
import kikaha.urouting.api.PathParam;
import kikaha.urouting.api.Produces;
import kikaha.urouting.api.QueryParam;

public class MicroRoutingParameterParser
extends MethodParametersExtractor {
    public MicroRoutingParameterParser(BiFunction<ExecutableElement, VariableElement, String> biFunction) {
        super(MicroRoutingParameterParser.createAnnotationRules(), biFunction);
    }

    static ChainedRules<VariableElement, Function<VariableElement, String>> createAnnotationRules() {
        ChainedRules chainedRules = new ChainedRules();
        chainedRules.with(APT.isAnnotatedWith(PathParam.class), variableElement -> MicroRoutingParameterParser.getParam(PathParam.class, variableElement.getAnnotation(PathParam.class).value(), variableElement)).and(APT.isAnnotatedWith(QueryParam.class), variableElement -> MicroRoutingParameterParser.getParam(QueryParam.class, variableElement.getAnnotation(QueryParam.class).value(), variableElement)).and(APT.isAnnotatedWith(HeaderParam.class), variableElement -> MicroRoutingParameterParser.getParam(HeaderParam.class, variableElement.getAnnotation(HeaderParam.class).value(), variableElement)).and(APT.isAnnotatedWith(CookieParam.class), variableElement -> MicroRoutingParameterParser.getParam(CookieParam.class, variableElement.getAnnotation(CookieParam.class).value(), variableElement)).and(APT.isAnnotatedWith(FormParam.class), variableElement -> MicroRoutingParameterParser.getParam(FormParam.class, variableElement.getAnnotation(FormParam.class).value(), variableElement)).and(APT.isAnnotatedWith(Context.class), variableElement -> String.format("methodDataProvider.getData( exchange, %s.class )", APT.asType((Element)variableElement))).and(APT.typeIs(AsyncResponse.class), variableElement -> "asyncResponse");
        return chainedRules;
    }

    static String getParam(Class<?> clazz, String string, VariableElement variableElement) {
        String string2 = APT.asType((Element)variableElement);
        return String.format("methodDataProvider.get%s( exchange, \"%s\", %s.class )", clazz.getSimpleName(), string, string2);
    }

    public static String extractHttpPathFrom(ExecutableElement executableElement) {
        Element element = executableElement.getEnclosingElement();
        Path path = element.getAnnotation(Path.class);
        String string = path != null ? path.value() : "/";
        Path path2 = executableElement.getAnnotation(Path.class);
        String string2 = path2 != null ? path2.value() : "/";
        return MicroRoutingParameterParser.generateHttpPath(string, string2);
    }

    public static String generateHttpPath(String string, String string2) {
        return String.format("/%s/%s/", string, string2).replaceAll("//+", "/");
    }

    public static String extractResponseContentTypeFrom(ExecutableElement executableElement) {
        Produces produces = executableElement.getAnnotation(Produces.class);
        if (produces == null) {
            produces = executableElement.getEnclosingElement().getAnnotation(Produces.class);
        }
        if (produces != null) {
            return produces.value();
        }
        return null;
    }
}

