/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.apt;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import kikaha.apt.APT;
import kikaha.apt.AnnotationProcessor;
import kikaha.apt.ClassGenerator;
import kikaha.apt.GenerableClass;
import kikaha.apt.MethodParametersExtractor;
import kikaha.urouting.api.OnClose;
import kikaha.urouting.api.OnError;
import kikaha.urouting.api.OnMessage;
import kikaha.urouting.api.OnOpen;
import kikaha.urouting.api.WebSocket;
import kikaha.urouting.apt.WebSocketData;
import kikaha.urouting.apt.WebSocketMethodData;
import kikaha.urouting.apt.WebSocketParameterParser;

@SupportedAnnotationTypes(value={"kikaha.urouting.api.*"})
public class MicroWebSocketAnnotationProcessor
extends AnnotationProcessor {
    static final MethodParametersExtractor parametersExtractor = new WebSocketParameterParser();
    ClassGenerator generator;

    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.generator = new ClassGenerator(processingEnvironment.getFiler(), "websocket-class.mustache");
    }

    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        try {
            Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(WebSocket.class);
            for (Element element : set2) {
                this.debug("  > " + element);
                this.generator.generate((GenerableClass)MicroWebSocketAnnotationProcessor.toWebSocketData((TypeElement)element));
            }
            return false;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    static WebSocketData toWebSocketData(TypeElement typeElement) {
        return new WebSocketData(APT.extractPackageName((Element)typeElement), APT.extractTypeName((String)APT.asType((Element)typeElement)), MicroWebSocketAnnotationProcessor.extractEndpointPathFrom(typeElement), APT.extractServiceInterfaceFrom((TypeElement)typeElement), MicroWebSocketAnnotationProcessor.retrieveMethodAnnotatedWith(typeElement, OnOpen.class), MicroWebSocketAnnotationProcessor.retrieveMethodAnnotatedWith(typeElement, OnMessage.class), MicroWebSocketAnnotationProcessor.retrieveMethodAnnotatedWith(typeElement, OnClose.class), MicroWebSocketAnnotationProcessor.retrieveMethodAnnotatedWith(typeElement, OnError.class));
    }

    static String extractEndpointPathFrom(TypeElement typeElement) {
        String string = typeElement.getAnnotation(WebSocket.class).value();
        return String.format("/%s/", string).replaceAll("//+", "/");
    }

    static WebSocketMethodData retrieveMethodAnnotatedWith(TypeElement typeElement, Class<? extends Annotation> clazz) {
        ExecutableElement executableElement = APT.retrieveFirstMethodAnnotatedWith((TypeElement)typeElement, clazz);
        if (executableElement == null) {
            return null;
        }
        return new WebSocketMethodData(executableElement.getSimpleName().toString(), parametersExtractor.extractMethodParamsFrom(executableElement), APT.extractReturnTypeFrom((ExecutableElement)executableElement));
    }
}

