/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.apt;

import io.undertow.websockets.core.CloseMessage;
import java.util.function.Function;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import kikaha.apt.APT;
import kikaha.apt.ChainedRules;
import kikaha.apt.MethodParametersExtractor;
import kikaha.core.modules.websocket.WebSocketSession;
import kikaha.urouting.api.HeaderParam;
import kikaha.urouting.api.PathParam;

public class WebSocketParameterParser
extends MethodParametersExtractor {
    public WebSocketParameterParser() {
        super(WebSocketParameterParser.createWebSocketAnnotationRules(), WebSocketParameterParser::trySerializeAnyOtherBodyContent);
    }

    static ChainedRules<VariableElement, Function<VariableElement, String>> createWebSocketAnnotationRules() {
        ChainedRules chainedRules = new ChainedRules();
        chainedRules.with(APT.isAnnotatedWith(PathParam.class), variableElement -> WebSocketParameterParser.getParam(PathParam.class, variableElement.getAnnotation(PathParam.class).value(), variableElement)).and(APT.isAnnotatedWith(HeaderParam.class), variableElement -> WebSocketParameterParser.getParam(HeaderParam.class, variableElement.getAnnotation(HeaderParam.class).value(), variableElement)).and(APT.typeIs(String.class), variableElement -> "message").and(APT.typeIs(CloseMessage.class), variableElement -> "cm").and(APT.typeIs(WebSocketSession.class), variableElement -> "session").and(APT.typeIs(Throwable.class), variableElement -> "cause");
        return chainedRules;
    }

    static String getParam(Class<?> clazz, String string, VariableElement variableElement) {
        String string2 = APT.asType((Element)variableElement);
        return String.format("dataProvider.get%s( session, \"%s\", %s.class )", clazz.getSimpleName(), string, string2);
    }

    static String trySerializeAnyOtherBodyContent(ExecutableElement executableElement, VariableElement variableElement) {
        String string = variableElement.asType().toString();
        return "dataProvider.getBody( session, message, " + string + ".class )";
    }
}

