/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Singleton;
import kikaha.config.Config;
import kikaha.urouting.api.AbstractConverter;
import kikaha.urouting.api.ConversionException;

@Singleton
@Typed(value={AbstractConverter.class})
public class DateConverter
extends AbstractConverter<Date> {
    @Inject
    Config config;
    SimpleDateFormat dateFormat;

    @PostConstruct
    public void loadConfig() {
        String string = this.config.getString("server.urouting.date-format", "yyyy-MM-dd HH:mm:ss");
        this.dateFormat = new SimpleDateFormat(string);
    }

    @Override
    public Date convert(String string) throws ConversionException {
        Date date = this.tryToConvertFromLong(string);
        if (date == null) {
            date = this.tryToConvertFromInternationDateFormat(string);
        }
        if (date == null) {
            this.throwCantConvertValueToDate(string);
        }
        return date;
    }

    private void throwCantConvertValueToDate(String string) throws ConversionException {
        throw new ConversionException(String.format("Can't convert '%s' to java.util.Date.", string));
    }

    private Date tryToConvertFromLong(String string) {
        try {
            long l = Long.parseLong(string);
            return new Date(l);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Date tryToConvertFromInternationDateFormat(String string) {
        try {
            return this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }
}

