/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.producers;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.IOException;
import javax.enterprise.inject.Typed;
import javax.inject.Singleton;
import kikaha.urouting.api.ContextProducer;
import kikaha.urouting.api.RoutingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Typed(value={ContextProducer.class})
public class FormDataProducer
implements ContextProducer<FormData> {
    private static final Logger log = LoggerFactory.getLogger(FormDataProducer.class);
    static final String COULD_NOT_PRODUCE_FORM_DATA = "Could not produce a FormData for this request.";
    final FormParserFactory formParserFactory = FormParserFactory.builder().build();

    @Override
    public FormData produce(HttpServerExchange httpServerExchange) throws RoutingException {
        try {
            FormDataParser formDataParser = this.formParserFactory.createParser(httpServerExchange);
            return formDataParser.parseBlocking();
        }
        catch (IOException | NullPointerException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new RoutingException(COULD_NOT_PRODUCE_FORM_DATA);
        }
    }
}

