/*
 * Decompiled with CFR 0.152.
 */
package kikaha.urouting.serializers;

import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import javax.enterprise.inject.Typed;
import javax.inject.Singleton;
import kikaha.core.modules.http.ContentType;
import kikaha.urouting.api.AbstractSerializer;
import kikaha.urouting.api.RoutingException;
import kikaha.urouting.api.Serializer;

@ContentType(value="text/plain")
@Singleton
@Typed(value={Serializer.class})
public class PlainTextSerializer
extends AbstractSerializer {
    @Override
    public <T> void serialize(T t, HttpServerExchange httpServerExchange, String string) throws IOException {
        if (ByteBuffer.class.isInstance(t)) {
            this.send(httpServerExchange, (ByteBuffer)t);
        } else if (String.class.isInstance(t)) {
            this.send(httpServerExchange, (String)t);
        } else {
            super.serialize(t, httpServerExchange, string);
        }
    }

    void send(HttpServerExchange httpServerExchange, ByteBuffer byteBuffer) {
        httpServerExchange.getResponseSender().send(byteBuffer);
    }

    void send(HttpServerExchange httpServerExchange, String string) {
        httpServerExchange.getResponseSender().send(string);
    }

    @Override
    public <T> void serialize(T t, OutputStream outputStream) throws RoutingException {
        try {
            if (t != null) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
                outputStreamWriter.write(t.toString());
                outputStreamWriter.close();
            }
        }
        catch (IOException iOException) {
            throw new RoutingException(iOException);
        }
    }
}

