/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.CompletableFutureWrapper;
import io.smallrye.context.SmallRyeThreadContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Jdk9CompletableFutureWrapper<T>
extends CompletableFutureWrapper<T> {
    public Jdk9CompletableFutureWrapper(SmallRyeThreadContext context, CompletableFuture<T> f, Executor executor, boolean minimal) {
        super(context, f, executor, minimal);
    }

    @Override
    public <U> CompletableFuture<U> newIncompleteFuture() {
        CompletableFuture ret = new CompletableFuture();
        return this.context.withContextCapture(ret, this.executor);
    }

    @Override
    public Executor defaultExecutor() {
        return this.executor;
    }

    @Override
    public CompletableFuture<T> copy() {
        return this.context.withContextCapture(this.f.copy(), this.executor);
    }

    @Override
    public CompletionStage<T> minimalCompletionStage() {
        return this.context.withContextCapture(this.f.minimalCompletionStage());
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier) {
        return this.context.withContextCapture(this.f.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), this.executor), this.executor);
    }

    @Override
    public CompletableFuture<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        return this.context.withContextCapture(this.f.completeAsync(this.context.contextualSupplierUnlessContextualized(supplier), executor), this.executor);
    }

    @Override
    public CompletableFuture<T> orTimeout(long timeout, TimeUnit unit) {
        return this.context.withContextCapture(this.f.orTimeout(timeout, unit), this.executor);
    }

    @Override
    public CompletableFuture<T> completeOnTimeout(T value, long timeout, TimeUnit unit) {
        return this.context.withContextCapture(this.f.completeOnTimeout(value, timeout, unit), this.executor);
    }
}

