/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context;

import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.context.impl.Contextualized;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class CompletionStageWrapper<T>
implements CompletionStage<T>,
Contextualized {
    private final CompletionStage<T> f;
    private final SmallRyeThreadContext context;
    private final Executor executor;

    public CompletionStageWrapper(SmallRyeThreadContext context, CompletionStage<T> f, Executor executor) {
        this.context = context;
        this.f = f;
        this.executor = executor;
    }

    private void checkDefaultExecutor() {
        if (this.executor == null) {
            throw new UnsupportedOperationException("Async methods not supported when no executor is specified");
        }
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.context.withContextCapture(this.f.toCompletableFuture(), this.executor);
    }

    @Override
    public CompletionStage<T> exceptionally(Function<Throwable, ? extends T> fn) {
        return this.context.withContextCapture(this.f.exceptionally(this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U> CompletionStage<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.context.withContextCapture(this.f.handle(this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.handleAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor));
    }

    @Override
    public <U> CompletionStage<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.handleAsync(this.context.contextualFunctionUnlessContextualized(fn), executor));
    }

    @Override
    public <U> CompletionStage<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.context.withContextCapture(this.f.thenApply(this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenApplyAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor));
    }

    @Override
    public <U> CompletionStage<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenApplyAsync(this.context.contextualFunctionUnlessContextualized(fn), executor));
    }

    @Override
    public CompletionStage<Void> thenAccept(Consumer<? super T> action) {
        return this.context.withContextCapture(this.f.thenAccept(this.context.contextualConsumerUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenAcceptAsync(this.context.contextualConsumerUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.context.withContextCapture(this.f.thenAcceptAsync(this.context.contextualConsumerUnlessContextualized(action), executor));
    }

    @Override
    public CompletionStage<Void> thenRun(Runnable action) {
        return this.context.withContextCapture(this.f.thenRun(this.context.contextualRunnableUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.thenRunAsync(this.context.contextualRunnableUnlessContextualized(action), executor));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.context.withContextCapture(this.f.thenCombine(other, this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenCombineAsync(other, this.context.contextualFunctionUnlessContextualized(fn), this.executor));
    }

    @Override
    public <U, V> CompletionStage<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenCombineAsync(other, this.context.contextualFunctionUnlessContextualized(fn), executor));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.context.withContextCapture(this.f.thenAcceptBoth(other, this.context.contextualConsumerUnlessContextualized(action)));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenAcceptBothAsync(other, this.context.contextualConsumerUnlessContextualized(action), this.executor));
    }

    @Override
    public <U> CompletionStage<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.context.withContextCapture(this.f.thenAcceptBothAsync(other, this.context.contextualConsumerUnlessContextualized(action), executor));
    }

    @Override
    public CompletionStage<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.context.withContextCapture(this.f.runAfterBoth(other, this.context.contextualRunnableUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.runAfterBothAsync(other, this.context.contextualRunnableUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.runAfterBothAsync(other, this.context.contextualRunnableUnlessContextualized(action), executor));
    }

    @Override
    public <U> CompletionStage<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.context.withContextCapture(this.f.applyToEither(other, this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.applyToEitherAsync(other, this.context.contextualFunctionUnlessContextualized(fn), this.executor));
    }

    @Override
    public <U> CompletionStage<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.context.withContextCapture(this.f.applyToEitherAsync(other, this.context.contextualFunctionUnlessContextualized(fn), executor));
    }

    @Override
    public CompletionStage<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.context.withContextCapture(this.f.acceptEither(other, this.context.contextualConsumerUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.acceptEitherAsync(other, this.context.contextualConsumerUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.context.withContextCapture(this.f.acceptEitherAsync(other, this.context.contextualConsumerUnlessContextualized(action), executor));
    }

    @Override
    public CompletionStage<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.context.withContextCapture(this.f.runAfterEither(other, this.context.contextualRunnableUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.runAfterEitherAsync(other, this.context.contextualRunnableUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.context.withContextCapture(this.f.runAfterEitherAsync(other, this.context.contextualRunnableUnlessContextualized(action), executor));
    }

    @Override
    public <U> CompletionStage<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.context.withContextCapture(this.f.thenCompose(this.context.contextualFunctionUnlessContextualized(fn)));
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.thenComposeAsync(this.context.contextualFunctionUnlessContextualized(fn), this.executor));
    }

    @Override
    public <U> CompletionStage<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.context.withContextCapture(this.f.thenComposeAsync(this.context.contextualFunctionUnlessContextualized(fn), executor));
    }

    @Override
    public CompletionStage<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.context.withContextCapture(this.f.whenComplete(this.context.contextualConsumerUnlessContextualized(action)));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        this.checkDefaultExecutor();
        return this.context.withContextCapture(this.f.whenCompleteAsync(this.context.contextualConsumerUnlessContextualized(action), this.executor));
    }

    @Override
    public CompletionStage<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.context.withContextCapture(this.f.whenCompleteAsync(this.context.contextualConsumerUnlessContextualized(action), executor));
    }

    public String toString() {
        return this.f.toString();
    }

    public int hashCode() {
        return this.f.hashCode();
    }

    public boolean equals(Object obj) {
        return this.f.equals(obj);
    }
}

