/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import io.smallrye.graphql.client.websocket.WebsocketSubprotocol;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public interface TypesafeGraphQLClientBuilder {
    public static TypesafeGraphQLClientBuilder newBuilder() {
        ServiceLoader<TypesafeGraphQLClientBuilder> loader = ServiceLoader.load(TypesafeGraphQLClientBuilder.class);
        Iterator<TypesafeGraphQLClientBuilder> iterator = loader.iterator();
        if (!iterator.hasNext()) {
            throw new ServiceConfigurationError("no " + TypesafeGraphQLClientBuilder.class.getName() + " in classpath");
        }
        TypesafeGraphQLClientBuilder graphQlClientBuilder = iterator.next();
        if (iterator.hasNext()) {
            throw new ServiceConfigurationError("more than one " + TypesafeGraphQLClientBuilder.class.getName() + " in classpath");
        }
        return graphQlClientBuilder;
    }

    public TypesafeGraphQLClientBuilder configKey(String var1);

    default public TypesafeGraphQLClientBuilder endpoint(String endpoint) {
        return this.endpoint(URI.create(endpoint));
    }

    public TypesafeGraphQLClientBuilder endpoint(URI var1);

    public TypesafeGraphQLClientBuilder websocketUrl(String var1);

    public TypesafeGraphQLClientBuilder executeSingleOperationsOverWebsocket(boolean var1);

    default public TypesafeGraphQLClientBuilder headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach(this::header);
        }
        return this;
    }

    public TypesafeGraphQLClientBuilder header(String var1, String var2);

    public TypesafeGraphQLClientBuilder initPayload(Map<String, Object> var1);

    public TypesafeGraphQLClientBuilder subprotocols(WebsocketSubprotocol ... var1);

    public TypesafeGraphQLClientBuilder websocketInitializationTimeout(Integer var1);

    public <T> T build(Class<T> var1);
}

