/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.entry.http;

import io.smallrye.graphql.cdi.config.GraphQLConfig;
import io.smallrye.graphql.entry.http.SmallRyeGraphQLServletLogging;
import io.smallrye.graphql.execution.ExecutionResponse;
import io.smallrye.graphql.execution.ExecutionService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="SmallRyeGraphQLExecutionServlet", urlPatterns={"/graphql/*"}, loadOnStartup=1)
public class ExecutionServlet
extends HttpServlet {
    private static final long serialVersionUID = -2859915918802356120L;
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(null);
    @Inject
    ExecutionService executionService;
    @Inject
    GraphQLConfig config;
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    private static final String QUERY = "query";
    private static final String OPERATION_NAME = "operationName";
    private static final String VARIABLES = "variables";
    private static final String EXTENSIONS = "extensions";
    private static final String APPLICATION_GRAPHQL = "application/graphql";

    public ExecutionServlet() {
    }

    public ExecutionServlet(ExecutionService executionService, GraphQLConfig config) {
        this.executionService = executionService;
        this.config = config;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            if (this.config.isAllowGet()) {
                JsonObject jsonObject = this.getJsonObjectFromQueryParameters(request);
                this.handleInput(jsonObject, response);
            } else {
                response.sendError(405, "GET Queries is not enabled");
            }
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
            throw ex;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            JsonObject jsonObjectFromBody = this.getJsonObjectFromBody(request);
            if (request.getQueryString() != null && !request.getQueryString().isEmpty() && this.config.isAllowPostWithQueryParameters()) {
                JsonObject jsonObjectFromQueryParameters = this.getJsonObjectFromQueryParameters(request);
                JsonObject mergedJsonObject = Json.createMergePatch((JsonValue)jsonObjectFromQueryParameters).apply((JsonValue)jsonObjectFromBody).asJsonObject();
                this.handleInput(mergedJsonObject, response);
            } else {
                this.handleInput(jsonObjectFromBody, response);
            }
        }
        catch (IOException ex) {
            SmallRyeGraphQLServletLogging.log.ioException(ex);
            throw ex;
        }
    }

    private JsonObject getJsonObjectFromQueryParameters(HttpServletRequest request) throws UnsupportedEncodingException {
        String extensions;
        String variables;
        String operationName;
        JsonObjectBuilder input = Json.createObjectBuilder();
        String query = request.getParameter(QUERY);
        if (query != null && !query.isEmpty()) {
            input.add(QUERY, URLDecoder.decode(query, "UTF8"));
        }
        if ((operationName = request.getParameter(OPERATION_NAME)) != null && !operationName.isEmpty()) {
            input.add(OPERATION_NAME, URLDecoder.decode(query, "UTF8"));
        }
        if ((variables = request.getParameter(VARIABLES)) != null && !variables.isEmpty()) {
            JsonObject jsonObject = ExecutionServlet.toJsonObject(URLDecoder.decode(variables, "UTF8"));
            input.add(VARIABLES, (JsonValue)jsonObject);
        }
        if ((extensions = request.getParameter(EXTENSIONS)) != null && !extensions.isEmpty()) {
            JsonObject jsonObject = ExecutionServlet.toJsonObject(URLDecoder.decode(extensions, "UTF8"));
            input.add(EXTENSIONS, (JsonValue)jsonObject);
        }
        return input.build();
    }

    /*
     * Exception decompiling
     */
    private JsonObject getJsonObjectFromBody(HttpServletRequest request) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleInput(JsonObject jsonInput, HttpServletResponse response) throws IOException {
        ExecutionResponse executionResponse = this.executionService.execute(jsonInput);
        if (executionResponse != null) {
            ServletOutputStream out = response.getOutputStream();
            response.setContentType(APPLICATION_JSON_UTF8);
            try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((OutputStream)out);){
                jsonWriter.writeObject(executionResponse.getExecutionResultAsJsonObject());
                out.flush();
            }
        }
    }

    private static JsonObject toJsonObject(String jsonString) {
        if (jsonString == null || jsonString.isEmpty()) {
            return null;
        }
        try (JsonReader jsonReader = Json.createReader((Reader)new StringReader(jsonString));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }
}

