/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.contact;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.info.ContactImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ContactReader {
    private ContactReader() {
    }

    public static Contact readContact(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        IoLogging.log.singleAnnotation("@Contact");
        AnnotationInstance nested = annotationValue.asNested();
        ContactImpl contact = new ContactImpl();
        contact.setName(JandexUtil.stringValue(nested, "name"));
        contact.setUrl(JandexUtil.stringValue(nested, "url"));
        contact.setEmail(JandexUtil.stringValue(nested, "email"));
        return contact;
    }

    public static Contact readContact(JsonNode node) {
        if (node == null) {
            return null;
        }
        IoLogging.log.singleJsonNode("Contact");
        ContactImpl contact = new ContactImpl();
        contact.setName(JsonUtil.stringProperty(node, "name"));
        contact.setUrl(JsonUtil.stringProperty(node, "url"));
        contact.setEmail(JsonUtil.stringProperty(node, "email"));
        ExtensionReader.readExtensions(node, contact);
        return contact;
    }
}

