/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiParser;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.ParseException;
import org.apache.commons.io.IOUtils;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.skyscreamer.jsonassert.JSONAssert;

public class OpenApiParserAndSerializerTest {
    private static String loadResource(URL testResource) throws IOException {
        return IOUtils.toString((URL)testResource, (String)"UTF-8");
    }

    private static void assertJsonEquals(String expected, String actual) throws JSONException {
        JSONAssert.assertEquals((String)expected, (String)actual, (boolean)true);
    }

    private static void assertYamlEquals(String original, String roundTrip) {
        Assert.assertEquals((Object)OpenApiParserAndSerializerTest.normalizeYaml(original), (Object)OpenApiParserAndSerializerTest.normalizeYaml(roundTrip));
    }

    private static String normalizeYaml(String yaml) {
        try {
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new StringReader(yaml));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("--")) {
                    builder.append(line);
                    builder.append("\n");
                }
                line = reader.readLine();
            }
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void doTest(String resource, Format format) throws IOException, ParseException, JSONException {
        URL testResource = OpenApiParserAndSerializerTest.class.getResource(resource);
        String original = OpenApiParserAndSerializerTest.loadResource(testResource);
        OpenAPI impl = OpenApiParser.parse((URL)testResource);
        String roundTrip = OpenApiSerializer.serialize((OpenAPI)impl, (Format)format);
        try {
            if (format == Format.JSON) {
                OpenApiParserAndSerializerTest.assertJsonEquals(original, roundTrip);
            } else {
                OpenApiParserAndSerializerTest.assertYamlEquals(original, roundTrip);
            }
        }
        catch (AssertionError e) {
            System.out.println("================");
            System.out.println(roundTrip);
            System.out.println("================");
            throw e;
        }
    }

    @Test
    public void testParseSimplest() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("simplest.json", Format.JSON);
    }

    @Test
    public void testParseSimplestYaml() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("simplest.yaml", Format.YAML);
    }

    @Test
    public void testParseInfo() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("info.json", Format.JSON);
    }

    @Test
    public void testParseInfoYaml() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("info.yaml", Format.YAML);
    }

    @Test
    public void testExternalDocs() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("externalDocs.json", Format.JSON);
    }

    @Test
    public void testExtensions() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("extensions.json", Format.JSON);
    }

    @Test
    public void testSecurity() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("security.json", Format.JSON);
    }

    @Test
    public void testServers() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("servers.json", Format.JSON);
    }

    @Test
    public void testServersYaml() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("servers.yaml", Format.YAML);
    }

    @Test
    public void testTags() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("tags.json", Format.JSON);
    }

    @Test
    public void testComponents_Callbacks() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-callbacks.json", Format.JSON);
    }

    @Test
    public void testComponents_Empty() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-empty.json", Format.JSON);
    }

    @Test
    public void testComponents_Examples() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-examples.json", Format.JSON);
    }

    @Test
    public void testComponents_Headers() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-headers.json", Format.JSON);
    }

    @Test
    public void testComponents_Links() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-links.json", Format.JSON);
    }

    @Test
    public void testComponents_Parameters() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-parameters.json", Format.JSON);
    }

    @Test
    public void testComponents_RequestBodies() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-requestBodies.json", Format.JSON);
    }

    @Test
    public void testComponents_Responses() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-responses.json", Format.JSON);
    }

    @Test
    public void testComponents_Schemas() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-schemas.json", Format.JSON);
    }

    @Test
    public void testComponents_SecuritySchemes() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("components-securitySchemes.json", Format.JSON);
    }

    @Test
    public void testPaths_AllOperations() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-all-operations.json", Format.JSON);
    }

    @Test
    public void testPaths_Empty() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-empty.json", Format.JSON);
    }

    @Test
    public void testPaths_GetCallbacks() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-callbacks.json", Format.JSON);
    }

    @Test
    public void testPaths_GetParameters() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-parameters.json", Format.JSON);
    }

    @Test
    public void testPaths_GetRequestBodyContent() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody-content.json", Format.JSON);
    }

    @Test
    public void testPaths_GetRequestBodyExample() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody-example.json", Format.JSON);
    }

    @Test
    public void testPaths_GetRequestBody() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-requestBody.json", Format.JSON);
    }

    @Test
    public void testPaths_GetResponseContent() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-content.json", Format.JSON);
    }

    @Test
    public void testPaths_GetResponseHeaders() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-headers.json", Format.JSON);
    }

    @Test
    public void testPaths_GetResponseLinks() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-response-links.json", Format.JSON);
    }

    @Test
    public void testPaths_GetResponses() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-responses.json", Format.JSON);
    }

    @Test
    public void testPaths_GetSecurity() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-security.json", Format.JSON);
    }

    @Test
    public void testPaths_GetServers() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get-servers.json", Format.JSON);
    }

    @Test
    public void testPaths_Get() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-get.json", Format.JSON);
    }

    @Test
    public void testPaths_Parameters() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-parameters.json", Format.JSON);
    }

    @Test
    public void testPaths_Ref() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-ref.json", Format.JSON);
    }

    @Test
    public void testPaths_Servers() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-servers.json", Format.JSON);
    }

    @Test
    public void testPaths_Extensions() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("paths-with-extensions.json", Format.JSON);
    }

    @Test
    public void testSchemas_Discriminator() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-discriminator.json", Format.JSON);
    }

    @Test
    public void testSchemas_AdditionalProperties() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-additionalProperties.json", Format.JSON);
    }

    @Test
    public void testSchemas_AllOf() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-allOf.json", Format.JSON);
    }

    @Test
    public void testSchemas_Composition() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-composition.json", Format.JSON);
    }

    @Test
    public void testSchemas_Example() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-example.json", Format.JSON);
    }

    @Test
    public void testSchemas_ExternalDocs() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-externalDocs.json", Format.JSON);
    }

    @Test
    public void testSchemas_MetaData() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-metaData.json", Format.JSON);
    }

    @Test
    public void testSchemas_XML() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("schemas-with-xml.json", Format.JSON);
    }

    @Test
    public void testEverything() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("_everything.json", Format.JSON);
    }

    @Test
    public void testEverythingYaml() throws IOException, ParseException, JSONException {
        OpenApiParserAndSerializerTest.doTest("_everything.yaml", Format.YAML);
    }
}

