/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import java.util.HashMap;
import org.jboss.jandex.DotName;
import org.junit.Assert;
import org.junit.Test;

public class FilteredIndexViewTest {
    @Test
    public void testAcceptsEmptyConfig() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
    }

    @Test
    public void testAccepts_IncludedClass_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "com.example.pkgA.MyBean,com.example.pkgA.MyClass");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
    }

    @Test
    public void testAccepts_ExcludedClass_IncludedClassPattern() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^(?:com.example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "com.example.pkgA.MyImpl");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedClassPattern_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^(?:com.example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_ExcludedSimpleClassPattern_NotIncludedClassMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.exclude.classes", "example.pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_ExcludedSimpleClassPattern_IncludedClassShorterMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "example.pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_ExcludedSimpleClassPattern_IncludedClassLongerMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:example.pkgA.My.*)$");
        properties.put("mp.openapi.scan.exclude.classes", "pkgA.MyImpl$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedSimpleClassPattern_ExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My(Bean|Class))$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedSimpleClassPattern_ExcludedPackagePrefix() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.My(Bean|Class))$");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedSimpleClassPattern_ExcludedPackagePatternDoesNotMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "(?:pkgA.MyBean)$");
        properties.put("mp.openapi.scan.exclude.packages", "example.pkg[AB]$");
        properties.put("mp.openapi.scan.packages", "^(com|org).example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"org.example.pkgB.MyImpl")));
    }

    @Test
    public void testAccepts_ExcludedPackageOverridesIncludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.TopLevelClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedPackageDoesNotMatch() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "example.pkgA$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedPackageOverridesExcludedPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example.pkgA");
        properties.put("mp.openapi.scan.exclude.packages", "com.example");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.TopLevelClass")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedPackageExcludesOtherPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.packages", "com.example.pkgA");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgB.MyImpl")));
    }

    @Test
    public void testAccepts_IncludedClassesImpliesOtherClassesExcluded() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("mp.openapi.scan.classes", "^com.example.pkgA.My(Bean|Class)$");
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyBean")));
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgA.MyClass")));
        Assert.assertFalse((boolean)view.accepts(DotName.createSimple((String)"com.example.pkgB.MyImpl")));
    }

    @Test
    public void testAccepts_EmptyPackage() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        OpenApiConfig config = IndexScannerTestBase.dynamicConfig(properties);
        FilteredIndexView view = new FilteredIndexView(null, config);
        Assert.assertTrue((boolean)view.accepts(DotName.createSimple((String)"int")));
    }
}

