/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Type;

public class DiscriminatorIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Discriminator, V, A, O, AB, OB> {
    public DiscriminatorIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.DISCRIMINATOR_MAPPING, Names.create(Discriminator.class));
    }

    @Override
    public Discriminator read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotationAs("@Schema", "Discriminator");
        String propertyName = (String)this.value(annotation, "discriminatorProperty");
        AnnotationInstance[] mapping = (AnnotationInstance[])this.value(annotation, "discriminatorMapping");
        if (propertyName == null && mapping == null) {
            return null;
        }
        Discriminator discriminator = OASFactory.createDiscriminator();
        if (propertyName != null) {
            discriminator.setPropertyName(propertyName);
        }
        if (mapping != null) {
            IoLogging.logger.annotationsList("@DiscriminatorMapping");
            Arrays.stream(mapping).map(this::readMapping).filter(Objects::nonNull).forEach(e -> discriminator.addMapping((String)e.getKey(), (String)e.getValue()));
        }
        return discriminator;
    }

    private Map.Entry<String, String> readMapping(AnnotationInstance mapping) {
        Schema schema;
        String propertyValue = (String)this.value(mapping, "value");
        Type schemaType = (Type)this.value(mapping, "schema");
        String schemaRef = schemaType != null ? ((schema = SchemaFactory.typeToSchema(this.scannerContext(), schemaType)) != null ? schema.getRef() : null) : null;
        if (propertyValue == null && schemaRef != null) {
            propertyValue = ModelUtil.nameFromRef(schemaRef);
        }
        if (propertyValue != null && schemaRef != null) {
            return DiscriminatorIO.entry(propertyValue, schemaRef);
        }
        return null;
    }
}

