/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.SmallRyeOpenAPI;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SmallRyeOpenAPIBuilderTest {
    SmallRyeOpenAPIBuilderTest() {
    }

    @Test
    void testStaticFileLoadedFromClasspath() throws Exception {
        URL loaderRoot = this.getClass().getClassLoader().getResource("classloader/META-INF/openapi.yaml").toURI().resolve("..").toURL();
        URLClassLoader custom = new URLClassLoader(new URL[]{loaderRoot}, Thread.currentThread().getContextClassLoader());
        SmallRyeOpenAPI result = SmallRyeOpenAPI.builder().withApplicationClassLoader((ClassLoader)custom).enableModelReader(false).enableStandardFilter(false).enableAnnotationScan(false).enableStandardStaticFiles(true).build();
        OpenAPI model = result.model();
        Assertions.assertEquals((Object)"Loaded from the class path", (Object)model.getInfo().getTitle());
    }

    @Test
    void testInvalidTypesInStaticFileDropped() {
        URL invalidResource = this.getClass().getClassLoader().getResource("io/smallrye/openapi/api/openapi-invalid-types.yaml");
        SmallRyeOpenAPI result = SmallRyeOpenAPI.builder().enableModelReader(false).enableStandardFilter(false).enableAnnotationScan(false).enableStandardStaticFiles(false).withCustomStaticFile(() -> {
            try {
                return invalidResource.openStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).build();
        OpenAPI model = result.model();
        Assertions.assertEquals((Object)"Invalid fields herein!", (Object)model.getInfo().getTitle());
        Assertions.assertEquals((Object)"1.0.0", (Object)model.getInfo().getVersion());
        Assertions.assertNull((Object)model.getInfo().getContact());
        Assertions.assertNull((Object)model.getInfo().getLicense());
        Assertions.assertNull((Object)model.getInfo().getSummary());
        Assertions.assertNull((Object)model.getServers());
        Assertions.assertNull((Object)model.getTags());
        Assertions.assertEquals((Object)OASFactory.createPaths(), (Object)model.getPaths());
        Assertions.assertNull((Object)model.getComponents());
        Assertions.assertNull((Object)model.getWebhooks());
    }
}

