/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.api.util.UnusedSchemaFilter;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UnusedSchemaFilterTest {
    UnusedSchemaFilter target;
    OpenAPI openAPI;

    UnusedSchemaFilterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.target = new UnusedSchemaFilter();
        this.openAPI = OASFactory.createOpenAPI();
        this.openAPI.paths(OASFactory.createPaths().addPathItem("/data", OASFactory.createPathItem().GET(OASFactory.createOperation().responses(OASFactory.createAPIResponses().addAPIResponse("200", OASFactory.createAPIResponse().content(OASFactory.createContent().addMediaType("text/plain", OASFactory.createMediaType().schema((Schema)OASFactory.createSchema().ref("#/components/schemas/Data"))).addMediaType("text/html", OASFactory.createMediaType().schema((Schema)OASFactory.createSchema().ref("http://example.com/schemas/Data?type=html"))))))))).components(OASFactory.createComponents().addSchema("Data", OASFactory.createSchema().addType(Schema.SchemaType.STRING).description("The data returned by the API")));
    }

    @Test
    void testUnusedSchemaPropertyRemoved() {
        this.openAPI.getComponents().addSchema("RemovedSchema", OASFactory.createSchema().addType(Schema.SchemaType.OBJECT).description("Schema to be removed, pass 1").addProperty("prop1", (Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedPropertySchema")).addProperty("prop2", (Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedPropertySchema")).addProperty("prop3", OASFactory.createSchema().addAllOf((Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedPropertySchema")).addAnyOf((Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedPropertySchema")).addOneOf((Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedPropertySchema")))).addSchema("RemovedPropertySchema", OASFactory.createSchema().addType(Schema.SchemaType.STRING).description("Schema to be removed, pass 2"));
        Assertions.assertEquals((int)3, (int)this.openAPI.getComponents().getSchemas().size());
        this.openAPI = FilterUtil.applyFilter((OASFilter)this.target, (OpenAPI)this.openAPI);
        Assertions.assertEquals((int)1, (int)this.openAPI.getComponents().getSchemas().size());
        Assertions.assertEquals((Object)"Data", this.openAPI.getComponents().getSchemas().keySet().iterator().next());
    }

    @Test
    void testUnusedOneOfSchemasRemoved() {
        this.openAPI.getComponents().addSchema("RemovedSchema", OASFactory.createSchema().addType(Schema.SchemaType.OBJECT).description("Schema to be removed, pass 1").addOneOf((Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedAllOfSchema1")).addOneOf((Schema)OASFactory.createSchema().ref("#/components/schemas/RemovedAllOfSchema2")).addOneOf(OASFactory.createSchema().addType(Schema.SchemaType.BOOLEAN))).addSchema("RemovedAllOfSchema1", OASFactory.createSchema().addType(Schema.SchemaType.INTEGER).description("Schema to be removed, pass 2")).addSchema("RemovedAllOfSchema2", OASFactory.createSchema().addType(Schema.SchemaType.STRING).description("Schema to be removed, pass 2"));
        Assertions.assertEquals((int)4, (int)this.openAPI.getComponents().getSchemas().size());
        this.openAPI = FilterUtil.applyFilter((OASFilter)this.target, (OpenAPI)this.openAPI);
        Assertions.assertEquals((int)1, (int)this.openAPI.getComponents().getSchemas().size());
        Assertions.assertEquals((Object)"Data", this.openAPI.getComponents().getSchemas().keySet().iterator().next());
    }
}

