/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.runtime.io.ModelIO;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ModelIOTest {
    ModelIOTest() {
    }

    @Test
    void testToLinkedMapDuplicateKeyThrowsException() {
        Stream<Map.Entry> stream = Stream.of("k1", "k1").map(k -> new AbstractMap.SimpleEntry<String, String>((String)k, ""));
        Collector collector = ModelIO.toLinkedMap();
        Assertions.assertThrows(IllegalStateException.class, () -> stream.collect(collector));
    }

    @Test
    void testToLinkedMapParallelCombined() {
        Stream<Map.Entry> stream = IntStream.range(0, 100).mapToObj(i -> new AbstractMap.SimpleEntry<String, String>(Integer.toString(i), i % 2 == 0 ? "" : null));
        Collector collector = ModelIO.toLinkedMap();
        Map result = (Map)((Stream)stream.parallel()).collect(collector);
        Assertions.assertEquals((int)100, (int)result.size());
        Assertions.assertEquals((long)50L, (long)result.values().stream().filter(Objects::isNull).count());
        Assertions.assertEquals((long)50L, (long)result.values().stream().filter(Objects::nonNull).count());
    }
}

