/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.model.ReferenceType;
import java.util.Arrays;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReferenceTypeTests {
    ReferenceTypeTests() {
    }

    @Test
    void testRefValueWithHttpUrl() {
        String ref = "https://www.example.com/openapi";
        AnnotationInstance annotation = AnnotationInstance.create((DotName)DotName.createSimple((String)""), null, Arrays.asList(AnnotationValue.createStringValue((String)"ref", (String)ref)));
        String outRef = ReferenceType.LINK.refValue(annotation);
        Assertions.assertEquals((Object)ref, (Object)outRef);
    }

    @Test
    void testRefValueWithRelativeUrl() {
        String ref = "./additional-schemas.json";
        AnnotationInstance annotation = AnnotationInstance.create((DotName)DotName.createSimple((String)""), null, Arrays.asList(AnnotationValue.createStringValue((String)"ref", (String)ref)));
        String outRef = ReferenceType.LINK.refValue(annotation);
        Assertions.assertEquals((Object)ref, (Object)outRef);
    }

    @Test
    void testRefValueWithValidLinkName() {
        String ref = "L1nk.T0_Something-Useful";
        AnnotationInstance annotation = AnnotationInstance.create((DotName)DotName.createSimple((String)""), null, Arrays.asList(AnnotationValue.createStringValue((String)"ref", (String)ref)));
        String outRef = ReferenceType.LINK.refValue(annotation);
        Assertions.assertEquals((Object)"#/components/links/L1nk.T0_Something-Useful", (Object)outRef);
    }
}

