/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.media.EncodingIO;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Collections;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Encoding;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class EncodingIOTest
extends IndexScannerTestBase {
    EncodingIOTest() {
    }

    @ParameterizedTest
    @CsvSource(value={"io.smallrye.openapi.runtime.io.media.EncodingIOTest$Endpoint1, PIPE_DELIMITED", "io.smallrye.openapi.runtime.io.media.EncodingIOTest$Endpoint2, "})
    void testReadEncodingStyle(Class<?> endpointClass, Encoding.Style expectedStyle) {
        FilteredIndexView index = new FilteredIndexView((IndexView)IndexScannerTestBase.indexOf(endpointClass), EncodingIOTest.emptyConfig());
        AnnotationScannerContext context = new AnnotationScannerContext(index, Thread.currentThread().getContextClassLoader(), Collections.emptyList(), EncodingIOTest.emptyConfig(), OASFactory.createOpenAPI());
        ClassInfo clazz = index.getClassByName(DotName.createSimple((String)endpointClass.getName()));
        AnnotationInstance annotation = clazz.method("getData", new Type[0]).annotation(DotName.createSimple((String)APIResponse.class.getName())).value("content").asNestedArray()[0].value("encoding").asNestedArray()[0];
        IOContext ioContext = IOContext.forScanning((AnnotationScannerContext)context);
        EncodingIO encodingIO = ioContext.encodingIO();
        Encoding.Style style = encodingIO.readStyle(annotation);
        Assertions.assertEquals((Object)expectedStyle, (Object)style);
    }

    static class Endpoint2 {
        Endpoint2() {
        }

        @APIResponse(content={@Content(encoding={@Encoding(style="invalid")})})
        public String getData() {
            return null;
        }
    }

    static class Endpoint1 {
        Endpoint1() {
        }

        @APIResponse(content={@Content(encoding={@Encoding(style="pipeDelimited")})})
        public String getData() {
            return null;
        }
    }
}

