/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.SmallRyeOpenAPI;
import java.io.ByteArrayInputStream;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class SchemaIOTest {
    SchemaIOTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(strings={"3.0.3", "3.1.0"})
    void testSchemaReferenceExpansion(String oasVersion) {
        OpenAPI result;
        SmallRyeOpenAPI.Builder builder = SmallRyeOpenAPI.builder().withCustomStaticFile(() -> new ByteArrayInputStream(("{  \"openapi\": \"" + oasVersion + "\",  \"components\": {    \"schemas\": {      \"s1\": { \"$ref\": \"s2\" },      \"s2\": { \"type\": \"string\" }    }  }}").getBytes()));
        System.setProperty("mp.openapi.extensions.smallrye.openapi", oasVersion);
        try {
            result = builder.build().model();
        }
        finally {
            System.clearProperty("mp.openapi.extensions.smallrye.openapi");
        }
        Assertions.assertEquals((Object)oasVersion, (Object)result.getOpenapi());
        Assertions.assertEquals((Object)"#/components/schemas/s2", (Object)((Schema)result.getComponents().getSchemas().get("s1")).getRef());
    }
}

