/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.schema;

import com.fasterxml.jackson.annotation.JsonValue;
import io.smallrye.openapi.api.util.ClassLoaderUtil;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SchemaFactoryTest
extends IndexScannerTestBase {
    SchemaFactoryTest() {
    }

    @Test
    void testResolveAsyncType() {
        Index index = SchemaFactoryTest.indexOf(new Class[0]);
        Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
        ParameterizedType target = ParameterizedType.create((DotName)DotName.createSimple((String)CompletableFuture.class.getName()), (Type[])new Type[]{STRING_TYPE}, null);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        Type result = SchemaFactory.resolveAsyncType((AnnotationScannerContext)context, (Type)target, Collections.emptyList());
        Assertions.assertEquals((Object)STRING_TYPE, (Object)result);
    }

    @Test
    void testWildcardSchemaIsEmpty() {
        Index index = SchemaFactoryTest.indexOf(new Class[0]);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        WildcardType type = WildcardType.create(null, (boolean)false);
        org.eclipse.microprofile.openapi.models.media.Schema result = SchemaFactory.typeToSchema((AnnotationScannerContext)context, (Type)type, null, Collections.emptyList());
        Assertions.assertNull((Object)result.getType());
    }

    @Test
    void testEnumToSchemaTypeUsesValueWithAnnotation() {
        Index index = SchemaFactoryTest.indexOf(ExampleEnum1.class);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        org.eclipse.microprofile.openapi.models.media.Schema result = SchemaFactory.enumToSchema((AnnotationScannerContext)context, (Type)Type.create(ExampleEnum1.class));
        Assertions.assertEquals(Arrays.asList(Schema.SchemaType.INTEGER), (Object)result.getType());
        Assertions.assertEquals((Object)"int32", (Object)result.getFormat());
        Assertions.assertEquals((Object)"An example enum with a value-driven schema type", (Object)result.getDescription());
    }

    @Test
    void testEnumToSchemaTypeUsesValueWithoutAnnotation() {
        Index index = SchemaFactoryTest.indexOf(ExampleEnum2.class);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        org.eclipse.microprofile.openapi.models.media.Schema result = SchemaFactory.enumToSchema((AnnotationScannerContext)context, (Type)Type.create(ExampleEnum2.class));
        Assertions.assertEquals(Arrays.asList(Schema.SchemaType.INTEGER), (Object)result.getType());
        Assertions.assertEquals((Object)"int64", (Object)result.getFormat());
        Assertions.assertNull((Object)result.getDescription());
    }

    @Test
    void testEnumToSchemaTypeWithEmptyEnum() {
        Index index = SchemaFactoryTest.indexOf(ExampleEnum3.class);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        org.eclipse.microprofile.openapi.models.media.Schema result = SchemaFactory.enumToSchema((AnnotationScannerContext)context, (Type)Type.create(ExampleEnum3.class));
        Assertions.assertEquals(Arrays.asList(Schema.SchemaType.STRING), (Object)result.getType());
        Assertions.assertEquals(Arrays.asList("VAL1", "VAL2"), (Object)result.getEnumeration());
    }

    @Test
    void testEnumToSchemaTypeWithInheritance() {
        Index index = SchemaFactoryTest.indexOf(ExampleEnum4.class, EnumValue4.class);
        AnnotationScannerContext context = new AnnotationScannerContext((IndexView)index, ClassLoaderUtil.getDefaultClassLoader(), SchemaFactoryTest.emptyConfig());
        org.eclipse.microprofile.openapi.models.media.Schema result = SchemaFactory.enumToSchema((AnnotationScannerContext)context, (Type)Type.create(ExampleEnum4.class));
        Assertions.assertEquals(Arrays.asList(Schema.SchemaType.BOOLEAN), (Object)result.getType());
        Assertions.assertEquals(Arrays.asList(true, false), (Object)result.getEnumeration());
    }

    @Test
    void testParseSchemaType() {
        for (SchemaType type : SchemaType.values()) {
            if (type == SchemaType.DEFAULT) {
                Assertions.assertNull((Object)SchemaFactory.parseSchemaType((String)type.name()));
                continue;
            }
            Assertions.assertEquals((Object)Schema.SchemaType.valueOf((String)type.name()), (Object)SchemaFactory.parseSchemaType((String)type.name()));
        }
    }

    @Schema(description="An example enum with a value-driven schema type")
    public static enum ExampleEnum1 {
        ONE(1),
        TWO(2);

        private final Integer value;

        private ExampleEnum1(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer getValue() {
            return this.value;
        }
    }

    public static enum ExampleEnum2 {
        ONE(1L),
        TWO(2L);

        private final Long value;

        private ExampleEnum2(Long value) {
            this.value = value;
        }

        @JsonValue
        public Long getValue() {
            return this.value;
        }
    }

    @Schema(description="An example enum with no values", enumeration={"VAL1", "VAL2"})
    public static final class ExampleEnum3
    extends Enum<ExampleEnum3> {
        private static final /* synthetic */ ExampleEnum3[] $VALUES;

        public static ExampleEnum3[] values() {
            return (ExampleEnum3[])$VALUES.clone();
        }

        public static ExampleEnum3 valueOf(String name) {
            return Enum.valueOf(ExampleEnum3.class, name);
        }

        private static /* synthetic */ ExampleEnum3[] $values() {
            return new ExampleEnum3[0];
        }

        static {
            $VALUES = ExampleEnum3.$values();
        }
    }

    @Schema
    public static enum ExampleEnum4 implements EnumValue4
    {
        TRUE(true),
        FALSE(false);

        final boolean value;

        private ExampleEnum4(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getValue() {
            return this.value;
        }
    }

    static interface EnumValue4 {
        @JsonValue
        public boolean getValue();
    }
}

