/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.security;

import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.security.OAuthFlowIO;
import io.smallrye.openapi.runtime.io.security.OAuthScopeIO;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.annotations.enums.SecuritySchemeType;
import org.eclipse.microprofile.openapi.annotations.security.OAuthFlows;
import org.eclipse.microprofile.openapi.annotations.security.OAuthScope;
import org.eclipse.microprofile.openapi.annotations.security.SecurityScheme;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SecuritySchemeIOTest
extends IndexScannerTestBase {
    SecuritySchemeIOTest() {
    }

    @Test
    void testReadFlow() {
        FilteredIndexView index = new FilteredIndexView((IndexView)IndexScannerTestBase.indexOf(Endpoint1.class), SecuritySchemeIOTest.emptyConfig());
        AnnotationScannerContext context = new AnnotationScannerContext(index, Thread.currentThread().getContextClassLoader(), Collections.emptyList(), SecuritySchemeIOTest.emptyConfig(), OASFactory.createOpenAPI());
        ClassInfo clazz = index.getClassByName(Endpoint1.class);
        AnnotationInstance annotation = clazz.annotation(SecurityScheme.class);
        AnnotationInstance flowAnnotation = annotation.value("flows").asNested().value("implicit").asNested();
        AnnotationInstance scopeAnnotation = flowAnnotation.value("scopes").asNestedArray()[0];
        IOContext ioContext = IOContext.forScanning((AnnotationScannerContext)context);
        OAuthScopeIO scopeIO = ioContext.oauthScopeIO();
        String value = scopeIO.read(scopeAnnotation);
        Assertions.assertNull((Object)value);
        OAuthFlowIO flowIO = ioContext.oauthFlowIO();
        OAuthFlow flow = flowIO.read(flowAnnotation);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("foo", null);
        Assertions.assertEquals(expected, (Object)flow.getScopes());
    }

    @SecurityScheme(securitySchemeName="OAuth2Authorization", type=SecuritySchemeType.OAUTH2, description="authentication needed to delete a profile", flows=@OAuthFlows(implicit=@org.eclipse.microprofile.openapi.annotations.security.OAuthFlow(authorizationUrl="https://example.com", scopes={@OAuthScope(name="foo")})))
    static class Endpoint1 {
        Endpoint1() {
        }
    }
}

