/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.OpenApiAnnotationScanner;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ComponentOrderTest
extends IndexScannerTestBase {
    ComponentOrderTest() {
    }

    @Test
    void testComponentsKeysSorted() throws Exception {
        Index index = ComponentOrderTest.indexOf(Class.forName(this.getClass().getPackage().getName() + ".sorttest1.package-info"), Class.forName(this.getClass().getPackage().getName() + ".sorttest2.package-info"));
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(ComponentOrderTest.emptyConfig(), (IndexView)index);
        Object[] expectedNames = new String[]{"123", "ABC", "DEF", "GHI", "KLM", "XYZ"};
        OpenAPI result = scanner.scan(new String[0]);
        ComponentOrderTest.printToConsole(result);
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getCallbacks().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getExamples().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getHeaders().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getLinks().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getParameters().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getRequestBodies().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getResponses().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getSchemas().keySet().toArray());
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getComponents().getSecuritySchemes().keySet().toArray());
    }

    @Test
    void testDefinitionTagOrderPreserved() throws Exception {
        Index index = ComponentOrderTest.indexOf(Class.forName(this.getClass().getPackage().getName() + ".sorttest1.package-info"), Class.forName(this.getClass().getPackage().getName() + ".sorttest2.package-info"));
        OpenApiAnnotationScanner scanner = new OpenApiAnnotationScanner(ComponentOrderTest.emptyConfig(), (IndexView)index);
        Object[] expectedNames = new String[]{"DEF", "XYZ", "ABC"};
        OpenAPI result = scanner.scan(new String[0]);
        ComponentOrderTest.printToConsole(result);
        Assertions.assertArrayEquals((Object[])expectedNames, (Object[])result.getTags().stream().map(Tag::getName).toArray());
    }
}

