/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.LogCapture;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.media.SchemaProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.RegisterExtension;

class SchemaPropertyNegativeTest
extends IndexScannerTestBase {
    @RegisterExtension
    public LogCapture logs = new LogCapture(ScannerLogging.class.getPackage().getName());

    SchemaPropertyNegativeTest() {
    }

    @BeforeEach
    public void beforeEach(TestInfo testInfo) {
        System.out.println(testInfo.getDisplayName());
    }

    @Test
    void testClassSchemaPropertyBlankName() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-blankname.json", BlankNameTest.class);
    }

    @Test
    void testClassSchemaPropertyDuplicateName() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-duplicatename.json", DuplicateNameTest.class);
    }

    @Test
    void testClassSchemaPropertyNegativeMultipleOf() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-negativemultipleof.json", NegativeMultipleOf.class);
    }

    @Test
    void testClassSchemaPropertyMaximumNotNumber() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maximumnotnumber.json", MaximumNotNumber.class);
    }

    @Test
    void testClassSchemaPropertyMinimumNotNumber() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minimumnotnumber.json", MinimumNotNumber.class);
    }

    @Test
    void testClassSchemaPropertyMinLengthNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minlengthnegative.json", MinLengthNegative.class);
    }

    @Test
    void testClassSchemaPropertyMaxLengthNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxlengthnegative.json", MaxLengthNegative.class);
    }

    @Test
    void testClassSchemaPropertyPatternInvalid() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-patterninvalid.json", PatternInvalid.class);
    }

    @Test
    void testClassSchemaPropertyMaxPropertiesNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxpropertiesnegative.json", MaxPropertiesNegative.class);
    }

    @Test
    void testClassSchemaPropertyMinPropertiesNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minpropertiesnegative.json", MinPropertiesNegative.class);
    }

    @Test
    void testClassSchemaPropertyRefWithOtherProps() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-refwithotherprops.json", RefWithOtherProps.class);
    }

    @Test
    void testClassSchemaPropertyDefaultValueWrongType() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-defaultvaluewrongtype.json", DefaultValueWrongType.class);
    }

    @Test
    void testClassSchemaPropertyMaxItemsNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-maxitemsnegative.json", MaxItemsNegative.class);
    }

    @Test
    void testClassSchemaPropertyMinItemsNegative() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-minitemsnegative.json", MinItemsNegative.class);
    }

    @Test
    void testClassSchemaPropertyImplementationMissing() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-implementationmissing.json", ImplementationMissing.class);
    }

    @Test
    void testClassSchemaPropertyNotMissing() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-notmissing.json", NotMissing.class);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyOneOfMissing() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-oneofmissing.json", OneOfMissing.class);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyAnyOfMissing() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-anyofmissing.json", AnyOfMissing.class);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Test
    void testClassSchemaPropertyAllOfMissing() throws Exception {
        SchemaPropertyNegativeTest.assertJsonEquals("components.schemas.schemaproperty-allofmissing.json", AllOfMissing.class);
        String expectedMessage = String.format("Could not find schema class in index: %s", MissingClass.class.getName());
        LogRecord record = this.logs.assertLogContaining(expectedMessage);
        Assertions.assertEquals((Object)Level.WARNING, (Object)record.getLevel());
    }

    @Schema(properties={@SchemaProperty(name="", type=SchemaType.STRING)})
    static class BlankNameTest {
        BlankNameTest() {
        }
    }

    @Schema(properties={@SchemaProperty(name="foo", type=SchemaType.STRING, defaultValue="5"), @SchemaProperty(name="foo", type=SchemaType.INTEGER)})
    static class DuplicateNameTest {
        DuplicateNameTest() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, multipleOf=-2.0)})
    static class NegativeMultipleOf {
        NegativeMultipleOf() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, maximum="foo")})
    static class MaximumNotNumber {
        MaximumNotNumber() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, minimum="foo")})
    static class MinimumNotNumber {
        MinimumNotNumber() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, minLength=-2)})
    static class MinLengthNegative {
        MinLengthNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, maxLength=-2)})
    static class MaxLengthNegative {
        MaxLengthNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, pattern="(invalid")})
    static class PatternInvalid {
        PatternInvalid() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.OBJECT, maxProperties=-2)})
    static class MaxPropertiesNegative {
        MaxPropertiesNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.OBJECT, minProperties=-2)})
    static class MinPropertiesNegative {
        MinPropertiesNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.STRING, ref="foobar")})
    static class RefWithOtherProps {
        RefWithOtherProps() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.INTEGER, defaultValue="foo")})
    static class DefaultValueWrongType {
        DefaultValueWrongType() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.ARRAY, maxItems=-2)})
    static class MaxItemsNegative {
        MaxItemsNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", type=SchemaType.ARRAY, minItems=-2)})
    static class MinItemsNegative {
        MinItemsNegative() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", implementation=MissingClass.class)})
    static class ImplementationMissing {
        ImplementationMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", not=MissingClass.class)})
    static class NotMissing {
        NotMissing() {
        }
    }

    static class MissingClass {
        public String example;

        MissingClass() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", oneOf={MissingClass.class})})
    static class OneOfMissing {
        OneOfMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", anyOf={MissingClass.class})})
    static class AnyOfMissing {
        AnyOfMissing() {
        }
    }

    @Schema(properties={@SchemaProperty(name="test", allOf={MissingClass.class})})
    static class AllOfMissing {
        AllOfMissing() {
        }
    }
}

