/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.spi;

import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.runtime.scanner.AnnotationScannerExtension;
import io.smallrye.openapi.runtime.scanner.IndexScannerTestBase;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.spi.AbstractAnnotationScanner;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.MethodInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class AbstractAnnotationScannerTest {
    AbstractAnnotationScannerTest() {
    }

    @Test
    void testMakePath() {
        String path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "", ""});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/"});
        Assertions.assertEquals((Object)"/", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"", "/bookings"});
        Assertions.assertEquals((Object)"/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/api", "/bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"api", "bookings"});
        Assertions.assertEquals((Object)"/api/bookings", (Object)path);
        path = AbstractAnnotationScanner.createPathFromSegments((String[])new String[]{"/", "/bookings", "{id}"});
        Assertions.assertEquals((Object)"/bookings/{id}", (Object)path);
    }

    @Test
    void testNoConfiguredProfile() {
        DummyOpenApiConfig config = new DummyOpenApiConfig();
        Operation operation = OASFactory.createOperation();
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredIncludeProfile() {
        DummyOpenApiConfig config = new DummyOpenApiConfig(){

            public Set<String> getScanProfiles() {
                return Collections.singleton("external");
            }
        };
        Operation operation = OASFactory.createOperation();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @Test
    void testConfiguredExcludeProfile() {
        DummyOpenApiConfig config = new DummyOpenApiConfig(){

            public Set<String> getScanExcludeProfiles() {
                return Collections.singleton("external");
            }
        };
        Operation operation = OASFactory.createOperation();
        boolean result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertTrue((boolean)result);
        operation.setExtensions(Collections.singletonMap("x-smallrye-profile-external", ""));
        result = AbstractAnnotationScanner.processProfiles((OpenApiConfig)config, (Extensible)operation);
        Assertions.assertFalse((boolean)result);
        Assertions.assertEquals((int)0, (int)operation.getExtensions().size());
    }

    @ParameterizedTest
    @CsvSource(value={"true,  p1, p1, PATH, true", "true,  p1, p1,     , false", "true,  p1, p2, PATH, false", "false, p1, p2,     , false", "true,  p1,   , PATH, false", "false, p1,   ,     , false", "     , p1, p1, PATH, false"})
    void testDefaultIsPathParameter(Boolean allowNaked, String searchParamName, String paramName, Parameter.In paramIn, boolean expectedResult) {
        OpenApiConfig config = IndexScannerTestBase.emptyConfig();
        config.setAllowNakedPathParameter(allowNaked);
        ResourceParameters params = new ResourceParameters();
        params.setOperationParameters(Arrays.asList(OASFactory.createParameter().name(paramName).in(paramIn)));
        DummyAnnotationScanner scanner = new DummyAnnotationScanner();
        AnnotationScannerContext context = new AnnotationScannerContext(null, Thread.currentThread().getContextClassLoader(), config);
        Assertions.assertEquals((Object)expectedResult, (Object)scanner.isPathParameter(context, searchParamName, params));
    }

    static class DummyOpenApiConfig
    implements OpenApiConfig {
        DummyOpenApiConfig() {
        }

        public <R, T> T getConfigValue(String propertyName, Class<R> type, Function<R, T> converter, Supplier<T> defaultValue) {
            return defaultValue.get();
        }

        public <R, T extends Collection<R>> T getConfigValues(String propertyName, Class<R> elementType, Function<List<R>, T> converter, Supplier<T> defaultValue) {
            return (T)((Collection)defaultValue.get());
        }

        public <R, T> Map<String, T> getConfigValueMap(String propertyNamePrefix, Class<R> type, Function<R, T> converter) {
            return Collections.emptyMap();
        }

        public void setAllowNakedPathParameter(Boolean allowNakedPathParameter) {
        }
    }

    static final class DummyAnnotationScanner
    extends AbstractAnnotationScanner {
        DummyAnnotationScanner() {
        }

        public String getName() {
            return "Dummy";
        }

        public OpenAPI scan(AnnotationScannerContext annotationScannerContext, OpenAPI oai) {
            return oai;
        }

        public boolean isAsyncResponse(MethodInfo method) {
            return false;
        }

        public boolean isPostMethod(MethodInfo method) {
            return false;
        }

        public boolean isDeleteMethod(MethodInfo method) {
            return false;
        }

        public boolean containsScannerAnnotations(List<AnnotationInstance> instances, List<AnnotationScannerExtension> extensions) {
            return false;
        }
    }
}

