/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.runtime.util.TypeParser;
import org.jboss.jandex.Type;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TypeParserTest {
    TypeParserTest() {
    }

    @Test
    void testParameterizedArrayComponent() {
        Type result = TypeParser.parse((String)"java.util.List<? extends java.lang.String[]>[][]");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Type.Kind.ARRAY, (Object)result.kind());
        Assertions.assertEquals((int)2, (int)result.asArrayType().dimensions());
        Assertions.assertEquals((Object)Type.Kind.PARAMETERIZED_TYPE, (Object)result.asArrayType().constituent().kind());
        Type typeArg = (Type)result.asArrayType().constituent().asParameterizedType().arguments().get(0);
        Assertions.assertEquals((Object)Type.Kind.WILDCARD_TYPE, (Object)typeArg.kind());
        Assertions.assertEquals((Object)Type.Kind.ARRAY, (Object)typeArg.asWildcardType().extendsBound().kind());
        Assertions.assertEquals((int)1, (int)typeArg.asWildcardType().extendsBound().asArrayType().dimensions());
        Assertions.assertEquals((Object)Type.Kind.CLASS, (Object)typeArg.asWildcardType().extendsBound().asArrayType().constituent().kind());
        Assertions.assertEquals((Object)String.class.getName(), (Object)typeArg.asWildcardType().extendsBound().asArrayType().constituent().asClassType().name().toString());
    }

    @Test
    void testPrimitive() {
        Type result = TypeParser.parse((String)"float");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Type.Kind.PRIMITIVE, (Object)result.kind());
        Assertions.assertEquals((Object)"float", (Object)result.name().toString());
    }

    @Test
    void testClassType() {
        Type result = TypeParser.parse((String)"java.lang.Object");
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Type.Kind.CLASS, (Object)result.kind());
        Assertions.assertEquals((Object)"java.lang.Object", (Object)result.name().toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"java.util.List<? super java.lang.String>", "java.util.List<? extends java.lang.String>", "java.util.List<?>"})
    void testWildcards(String typeSignature) {
        Type result = TypeParser.parse((String)typeSignature);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((Object)Type.Kind.PARAMETERIZED_TYPE, (Object)result.kind());
        Assertions.assertEquals((Object)"java.util.List", (Object)result.name().toString());
        Assertions.assertEquals((int)1, (int)result.asParameterizedType().arguments().size());
        Assertions.assertEquals((Object)Type.Kind.WILDCARD_TYPE, (Object)((Type)result.asParameterizedType().arguments().get(0)).kind());
    }
}

