/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.restclient.async;

import io.smallrye.restclient.async.ExecutorServiceWrapper;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;

public class AsyncInvocationInterceptorHandler {
    private static final ThreadLocal<Collection<AsyncInvocationInterceptor>> threadBoundInterceptors = new ThreadLocal();

    public static void register(Collection<AsyncInvocationInterceptor> interceptor) {
        threadBoundInterceptors.set(interceptor);
    }

    public static ExecutorService wrapExecutorService(ExecutorService service) {
        return new ExecutorServiceWrapper(service, new Decorator());
    }

    private AsyncInvocationInterceptorHandler() {
    }

    public static class Decorator
    implements ExecutorServiceWrapper.Decorator {
        @Override
        public Runnable decorate(Runnable runnable) {
            Collection interceptors = (Collection)threadBoundInterceptors.get();
            threadBoundInterceptors.remove();
            return () -> {
                if (interceptors != null) {
                    interceptors.forEach(AsyncInvocationInterceptor::applyContext);
                }
                runnable.run();
            };
        }

        public <V> Callable<V> decorate(Callable<V> callable) {
            Collection interceptors = (Collection)threadBoundInterceptors.get();
            threadBoundInterceptors.remove();
            return () -> {
                if (interceptors != null) {
                    interceptors.forEach(AsyncInvocationInterceptor::applyContext);
                }
                return callable.call();
            };
        }
    }
}

