/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.python;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkUserAppException;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.deploy.PythonRunner$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.python.PythonHelper;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.RedirectThread;
import org.apache.spark.util.RedirectThread$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import py4j.GatewayServer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public final class PythonHelper$
implements Logging {
    public static final PythonHelper$ MODULE$ = new PythonHelper$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public <T extends PythonHelper.SparkEntryPoint> void exec(T entryPointObj, String pythonCode) {
        File pythonFile = File.createTempFile("pythontransform", ".py");
        String pyFiles = "";
        scala.collection.immutable.Seq otherArgs = (scala.collection.immutable.Seq)Nil$.MODULE$;
        SparkSession session = entryPointObj.session();
        SparkConf sparkConf = session.sparkContext().getConf();
        String secret = Utils$.MODULE$.createSecret(sparkConf);
        String pythonExec = (String)((Option)sparkConf.get((ConfigEntry)package$.MODULE$.PYSPARK_DRIVER_PYTHON())).orElse((Function0 & Serializable)() -> (Option)sparkConf.get((ConfigEntry)package$.MODULE$.PYSPARK_PYTHON())).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_DRIVER_PYTHON")).orElse((Function0 & Serializable)() -> scala.sys.package$.MODULE$.env().get((Object)"PYSPARK_PYTHON")).getOrElse((Function0 & Serializable)() -> "python");
        PrintWriter pw = new PrintWriter(pythonFile);
        pw.write(pythonCode);
        pw.close();
        pythonFile.deleteOnExit();
        String formattedPythonFile = PythonRunner$.MODULE$.formatPath(pythonFile.getAbsolutePath(), PythonRunner$.MODULE$.formatPath$default$2());
        String[] formattedPyFiles = this.resolvePyFiles(PythonRunner$.MODULE$.formatPaths(pyFiles, PythonRunner$.MODULE$.formatPaths$default$2()));
        InetAddress localhost = InetAddress.getLoopbackAddress();
        GatewayServer gatewayServer = new GatewayServer.GatewayServerBuilder().authToken(secret).javaPort(0).javaAddress(localhost).callbackClient(25334, localhost, secret).entryPoint(entryPointObj).build();
        Thread thread = new Thread(new Runnable(gatewayServer){
            private final GatewayServer gatewayServer$1;

            public void run() {
                Utils$.MODULE$.logUncaughtExceptions((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.gatewayServer$1.start());
            }
            {
                this.gatewayServer$1 = gatewayServer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.python.PythonHelper$$anon$1 )}, serializedLambda);
            }
        });
        thread.setName("py4j-gateway-init");
        thread.setDaemon(true);
        thread.start();
        thread.join();
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "py4j gateway started");
        ArrayBuffer pathElements = new ArrayBuffer();
        pathElements.$plus$plus$eq((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])formattedPyFiles));
        pathElements.$plus$eq((Object)PythonUtils$.MODULE$.sparkPythonPath());
        pathElements.$plus$eq(scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> ""));
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths(pathElements.toSeq());
        ProcessBuilder builder = new ProcessBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)pythonExec, (List)new .colon.colon((Object)formattedPythonFile, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)otherArgs)).asJava());
        Map<String, String> env = builder.environment();
        env.put("PYTHONPATH", pythonPath);
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("PYSPARK_GATEWAY_SECRET", secret);
        ((Option)sparkConf.get((ConfigEntry)package$.MODULE$.PYSPARK_PYTHON())).foreach((Function1 & Serializable)x$1 -> env.put("PYSPARK_PYTHON", (String)x$1));
        scala.sys.package$.MODULE$.env().get((Object)"PYTHONHASHSEED").foreach((Function1 & Serializable)x$2 -> env.put("PYTHONHASHSEED", (String)x$2));
        builder.redirectErrorStream(true);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "starting python process");
        try {
            Process process = builder.start();
            new RedirectThread(process.getInputStream(), (OutputStream)System.out, "redirect output", RedirectThread$.MODULE$.$lessinit$greater$default$4()).start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new SparkUserAppException(exitCode);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable)() -> "python process ended successfully");
        }
        finally {
            gatewayServer.shutdown();
        }
    }

    private String[] resolvePyFiles(String[] pyFiles) {
        LazyRef dest$lzy = new LazyRef();
        return (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])pyFiles), (Function1 & Serializable)pyFile -> {
            if (pyFile.endsWith(".py")) {
                File source = new File((String)pyFile);
                if (source.exists() && source.isFile() && source.canRead()) {
                    Files.copy(source.toPath(), new File(PythonHelper$.dest$1(dest$lzy), source.getName()).toPath(), new CopyOption[0]);
                    return new Some((Object)PythonHelper$.dest$1(dest$lzy).getAbsolutePath());
                }
                return None$.MODULE$;
            }
            return new Some(pyFile);
        }, ClassTag$.MODULE$.apply(String.class))));
    }

    private static final /* synthetic */ File dest$lzycompute$1(LazyRef dest$lzy$1) {
        File file;
        LazyRef lazyRef = dest$lzy$1;
        synchronized (lazyRef) {
            File file2;
            if (dest$lzy$1.initialized()) {
                file2 = (File)dest$lzy$1.value();
            } else {
                String x$1 = "localPyFiles";
                String x$2 = Utils$.MODULE$.createTempDir$default$1();
                file2 = (File)dest$lzy$1.initialize((Object)Utils$.MODULE$.createTempDir(x$2, "localPyFiles"));
            }
            file = file2;
        }
        return file;
    }

    private static final File dest$1(LazyRef dest$lzy$1) {
        if (dest$lzy$1.initialized()) {
            return (File)dest$lzy$1.value();
        }
        return PythonHelper$.dest$lzycompute$1(dest$lzy$1);
    }

    private PythonHelper$() {
    }
}

