/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.confluent;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.confluent.IncompatibleSchemaException;
import org.apache.spark.sql.confluent.IncompatibleSchemaException$;
import org.apache.spark.sql.confluent.SubjectType$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005f\u0001\u0002\t\u0012\u0001qA\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006\u007f\u0001!\t\u0001\u0011\u0005\t/\u0002A)\u0019!C\u00011\"A1\r\u0001EC\u0002\u0013%A\rC\u0003v\u0001\u0011\u0005a\u000fC\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!I\u0011Q\t\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t)\u0007\u0001C\u0001\u0003OBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002t\u0001!I!!\u001e\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u00111\u0011\u0001\u0005\u0012\u0005\u0015\u0005bBAK\u0001\u0011E\u0011q\u0013\u0002\u0010\u0007>tg\r\\;f]R\u001cE.[3oi*\u0011!cE\u0001\nG>tg\r\\;f]RT!\u0001F\u000b\u0002\u0007M\fHN\u0003\u0002\u0017/\u0005)1\u000f]1sW*\u0011\u0001$G\u0001\u0007CB\f7\r[3\u000b\u0003i\t1a\u001c:h\u0007\u0001)\"!H#\u0014\t\u0001qBE\u000b\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d*\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgn\u001a\t\u0003WMr!\u0001L\u0019\u000f\u00055\u0002T\"\u0001\u0018\u000b\u0005=Z\u0012A\u0002\u001fs_>$h(C\u0001\"\u0013\t\u0011\u0004%A\u0004qC\u000e\\\u0017mZ3\n\u0005Q*$\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u001a!\u0003E\u00198\r[3nCJ+w-[:uef,&\u000f\u001c\t\u0003qqr!!\u000f\u001e\u0011\u00055\u0002\u0013BA\u001e!\u0003\u0019\u0001&/\u001a3fM&\u0011QH\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m\u0002\u0013A\u0002\u001fj]&$h\b\u0006\u0002B-B\u0019!\tA\"\u000e\u0003E\u0001\"\u0001R#\r\u0001\u0011)a\t\u0001b\u0001\u000f\n\t1+\u0005\u0002I\u0017B\u0011q$S\u0005\u0003\u0015\u0002\u0012qAT8uQ&tw\r\u0005\u0002M)6\tQJ\u0003\u0002O\u001f\u0006q1o\u00195f[\u0006\u0014XmZ5tiJL(B\u0001)R\u0003\u0015Y\u0017MZ6b\u0015\t\u0011\"KC\u0001T\u0003\tIw.\u0003\u0002V\u001b\na\u0001+\u0019:tK\u0012\u001c6\r[3nC\")aG\u0001a\u0001o\u0005\u00111O]\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A,T\u0001\u0007G2LWM\u001c;\n\u0005y[&\u0001F*dQ\u0016l\u0017MU3hSN$(/_\"mS\u0016tG\u000f\u000b\u0002\u0004AB\u0011q$Y\u0005\u0003E\u0002\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0011M,(M[3diN,\u0012!\u001a\t\u0004M.lW\"A4\u000b\u0005!L\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003U\u0002\n!bY8mY\u0016\u001cG/[8o\u0013\tawMA\u0002TKR\u0004\"A\\:\u000e\u0003=T!\u0001]9\u0002\t1\fgn\u001a\u0006\u0002e\u0006!!.\u0019<b\u0013\tit\u000e\u000b\u0002\u0005A\u0006Qq-\u001a;Tk\nTWm\u0019;\u0015\u0007]:\u0018\u0010C\u0003y\u000b\u0001\u0007q'A\u0003u_BL7\rC\u0003{\u000b\u0001\u000710A\u0006tk\nTWm\u0019;UsB,\u0007c\u0001?\u0002\u00149\u0019Q0a\u0004\u000f\u0007y\fiAD\u0002\u0000\u0003\u0017qA!!\u0001\u0002\n9!\u00111AA\u0004\u001d\ri\u0013QA\u0005\u00025%\u0011\u0001$G\u0005\u0003-]I!\u0001F\u000b\n\u0005I\u0019\u0012bAA\t#\u0005Y1+\u001e2kK\u000e$H+\u001f9f\u0013\u0011\t)\"a\u0006\u0003\u0017M+(M[3diRK\b/\u001a\u0006\u0004\u0003#\t\u0012\u0001\u0002;fgR$\"!!\b\u0011\u0007}\ty\"C\u0002\u0002\"\u0001\u0012A!\u00168ji\u0006\t2/\u001a;PeV\u0003H-\u0019;f'\u000eDW-\\1\u0015\u0011\u0005\u001d\u00121GA\u001c\u0003w\u0001baHA\u0015\u0003[\u0019\u0015bAA\u0016A\t1A+\u001e9mKJ\u00022aHA\u0018\u0013\r\t\t\u0004\t\u0002\u0004\u0013:$\bBBA\u001b\u000f\u0001\u0007q'A\u0004tk\nTWm\u0019;\t\r\u0005er\u00011\u0001D\u0003%qWm^*dQ\u0016l\u0017\rC\u0005\u0002>\u001d\u0001\n\u00111\u0001\u0002@\u0005yQ.\u001e;vC2\u0014V-\u00193DQ\u0016\u001c7\u000eE\u0002 \u0003\u0003J1!a\u0011!\u0005\u001d\u0011un\u001c7fC:\f1d]3u\u001fJ,\u0006\u000fZ1uKN\u001b\u0007.Z7bI\u0011,g-Y;mi\u0012\u001aTCAA%U\u0011\ty$a\u0013,\u0005\u00055\u0003\u0003BA(\u00033j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0016!\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\n\tFA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fab]3u\u001fJ<U\r^*dQ\u0016l\u0017\r\u0006\u0004\u0002(\u0005\u0005\u00141\r\u0005\u0007\u0003kI\u0001\u0019A\u001c\t\r\u0005e\u0012\u00021\u0001D\u0003q9W\r\u001e'bi\u0016\u001cHoU2iK6\fgI]8n\u0007>tg\r\\;f]R$B!a\n\u0002j!1\u0011Q\u0007\u0006A\u0002]\nacZ3u'\u000eDW-\\1Ge>l7i\u001c8gYV,g\u000e\u001e\u000b\u0005\u0003O\ty\u0007C\u0004\u0002r-\u0001\r!!\f\u0002\u0005%$\u0017A\u0004:fO&\u001cH/\u001a:TG\",W.\u0019\u000b\u0007\u0003O\t9(!\u001f\t\r\u0005UB\u00021\u00018\u0011\u0019\tY\b\u0004a\u0001\u0007\u000611o\u00195f[\u0006\fAb]2iK6\fW\t_5tiN$B!a\u0010\u0002\u0002\"1\u0011QG\u0007A\u0002]\n!c\u00195fG.\u001c6\r[3nC\u000e\u000bgNU3bIR1\u0011qQAG\u0003#\u0003BaKAEo%\u0019\u00111R\u001b\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002\u0010:\u0001\raQ\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007BBAJ\u001d\u0001\u00071)\u0001\u0006sK\u0006$7k\u00195f[\u0006\f\u0011d\u00195fG.\u001c6\r[3nC6+H/^1m%\u0016\fG-\u00192mKR1\u0011qQAM\u0003;Ca!a'\u0010\u0001\u0004\u0019\u0015aB:dQ\u0016l\u0017-\r\u0005\u0007\u0003?{\u0001\u0019A\"\u0002\u000fM\u001c\u0007.Z7be\u0001")
public class ConfluentClient<S extends ParsedSchema>
implements Logging,
Serializable {
    private transient SchemaRegistryClient sr;
    private transient Set<String> subjects;
    private final String schemaRegistryUrl;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile transient byte bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SchemaRegistryClient sr$lzycompute() {
        ConfluentClient confluentClient = this;
        synchronized (confluentClient) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.sr = new CachedSchemaRegistryClient(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.schemaRegistryUrl, (List)Nil$.MODULE$)).asJava(), 1000, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new AvroSchemaProvider(), (List)new .colon.colon((Object)new JsonSchemaProvider(), (List)Nil$.MODULE$))).asJava(), null);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.sr;
    }

    public SchemaRegistryClient sr() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.sr$lzycompute();
        }
        return this.sr;
    }

    private Set<String> subjects$lzycompute() {
        ConfluentClient confluentClient = this;
        synchronized (confluentClient) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.subjects = (Set)Set$.MODULE$.apply(CollectionConverters$.MODULE$.CollectionHasAsScala(this.sr().getAllSubjects()).asScala().toSeq());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.subjects;
    }

    private Set<String> subjects() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.subjects$lzycompute();
        }
        return this.subjects;
    }

    public String getSubject(String topic, Enumeration.Value subjectType) {
        Enumeration.Value value = subjectType;
        Enumeration.Value value2 = SubjectType$.MODULE$.key();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return new StringBuilder(4).append(topic).append("-key").toString();
        }
        Enumeration.Value value4 = SubjectType$.MODULE$.value();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return new StringBuilder(6).append(topic).append("-value").toString();
        }
        throw new MatchError((Object)value);
    }

    public void test() {
        this.sr().getMode();
    }

    public Tuple2<Object, S> setOrUpdateSchema(String subject, S newSchema, boolean mutualReadCheck) {
        if (!this.schemaExists(subject)) {
            return this.registerSchema(subject, newSchema);
        }
        Tuple2 latestSchema = this.getLatestSchemaFromConfluent(subject);
        if (!latestSchema._2().equals(newSchema)) {
            String modeForLogging;
            Function2 & Serializable checkSchemaFunc = mutualReadCheck ? (Function2 & Serializable)(schema1, schema2) -> this.checkSchemaMutualReadable(schema1, schema2) : (Function2 & Serializable)(dataSchema, readSchema) -> this.checkSchemaCanRead(dataSchema, readSchema);
            scala.collection.immutable.Seq compatibilityViolations = (scala.collection.immutable.Seq)checkSchemaFunc.apply(latestSchema._2(), newSchema);
            String string = modeForLogging = mutualReadCheck ? "forward & backward" : "backward";
            if (compatibilityViolations.isEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("New schema for subject ").append(subject).append(" is ").append(modeForLogging).append(" compatible with latest schema: new=").append(newSchema).toString());
                return this.registerSchema(subject, newSchema);
            }
            String msg = new StringBuilder(61).append("New schema for subject ").append(subject).append(" is not ").append(modeForLogging).append(" compatible with latest schema").toString();
            this.logError((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append(msg).append(": latest=").append(latestSchema._2()).append(" new=").append(newSchema).append(" violations=").append(compatibilityViolations.mkString(";")).toString());
            throw new IncompatibleSchemaException(msg, IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("New schema for ").append(subject).append(" is equal to latest schema").toString());
        return latestSchema;
    }

    public boolean setOrUpdateSchema$default$3() {
        return false;
    }

    public Tuple2<Object, S> setOrGetSchema(String subject, S newSchema) {
        if (!this.schemaExists(subject)) {
            return this.registerSchema(subject, newSchema);
        }
        return this.getLatestSchemaFromConfluent(subject);
    }

    public Tuple2<Object, S> getLatestSchemaFromConfluent(String subject) {
        SchemaMetadata m = this.sr().getLatestSchemaMetadata(subject);
        return this.getSchemaFromConfluent(m.getId());
    }

    public Tuple2<Object, S> getSchemaFromConfluent(int id) {
        ParsedSchema avroSchema = this.sr().getSchemaById(id);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)avroSchema);
    }

    private Tuple2<Object, S> registerSchema(String subject, S schema) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Register new schema for ").append(subject).append(": schema=").append(schema).toString());
        int schemaId = this.sr().register(subject, schema);
        this.subjects().add((Object)subject);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)schemaId), schema);
    }

    private boolean schemaExists(String subject) {
        return this.subjects().contains((Object)subject);
    }

    public scala.collection.immutable.Seq<String> checkSchemaCanRead(S dataSchema, S readSchema) {
        return CollectionConverters$.MODULE$.ListHasAsScala(readSchema.isBackwardCompatible(dataSchema)).asScala().toSeq();
    }

    public scala.collection.immutable.Seq<String> checkSchemaMutualReadable(S schema1, S schema2) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(schema1.isBackwardCompatible(schema2)).asScala().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(schema2.isBackwardCompatible(schema1)).asScala())).toSeq();
    }

    public ConfluentClient(String schemaRegistryUrl) {
        this.schemaRegistryUrl = schemaRegistryUrl;
        Logging.$init$((Logging)this);
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Initialize confluent schema registry with url ").append($this.schemaRegistryUrl).toString());
    }
}

