/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.confluent.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.confluent.IncompatibleSchemaException;
import org.apache.spark.sql.confluent.IncompatibleSchemaException$;
import org.apache.spark.sql.confluent.avro.AvroSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class AvroSchemaConverter$ {
    public static final AvroSchemaConverter$ MODULE$ = new AvroSchemaConverter$();
    private static RandomUUIDGenerator uuidGenerator;
    private static Schema nullSchema;
    private static volatile byte bitmap$0;

    private RandomUUIDGenerator uuidGenerator$lzycompute() {
        AvroSchemaConverter$ avroSchemaConverter$ = this;
        synchronized (avroSchemaConverter$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                uuidGenerator = new RandomUUIDGenerator(new Random().nextLong());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return uuidGenerator;
    }

    private RandomUUIDGenerator uuidGenerator() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.uuidGenerator$lzycompute();
        }
        return uuidGenerator;
    }

    private Schema nullSchema$lzycompute() {
        AvroSchemaConverter$ avroSchemaConverter$ = this;
        synchronized (avroSchemaConverter$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                nullSchema = Schema.create((Schema.Type)Schema.Type.NULL);
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return nullSchema;
    }

    private Schema nullSchema() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.nullSchema$lzycompute();
        }
        return nullSchema;
    }

    public AvroSchemaConverter.SchemaType toSqlType(Schema avroSchema) {
        return this.toSqlTypeHelper(avroSchema, (Set<String>)Predef$.MODULE$.Set().empty());
    }

    public AvroSchemaConverter.SchemaType toSqlTypeHelper(Schema avroSchema, Set<String> existingRecordNames) {
        Schema.Type type;
        block23: {
            SeqOps seqOps;
            SeqOps seqOps2;
            Seq seq;
            boolean bl;
            while (true) {
                if (Schema.Type.INT.equals(type = avroSchema.getType())) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Date) {
                        return new AvroSchemaConverter.SchemaType((DataType)DateType$.MODULE$, false);
                    }
                    return new AvroSchemaConverter.SchemaType((DataType)IntegerType$.MODULE$, false);
                }
                if (Schema.Type.STRING.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.BOOLEAN.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)BooleanType$.MODULE$, false);
                }
                if (Schema.Type.BYTES.equals(type) ? true : Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.Decimal) {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return new AvroSchemaConverter.SchemaType((DataType)new DecimalType(decimal.getPrecision(), decimal.getScale()), false);
                    }
                    return new AvroSchemaConverter.SchemaType((DataType)BinaryType$.MODULE$, false);
                }
                if (Schema.Type.DOUBLE.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
                if (Schema.Type.FLOAT.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)FloatType$.MODULE$, false);
                }
                if (Schema.Type.LONG.equals(type)) {
                    LogicalType logicalType = avroSchema.getLogicalType();
                    if (logicalType instanceof LogicalTypes.TimestampMillis ? true : logicalType instanceof LogicalTypes.TimestampMicros) {
                        return new AvroSchemaConverter.SchemaType((DataType)TimestampType$.MODULE$, false);
                    }
                    return new AvroSchemaConverter.SchemaType((DataType)LongType$.MODULE$, false);
                }
                if (Schema.Type.ENUM.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)StringType$.MODULE$, false);
                }
                if (Schema.Type.NULL.equals(type)) {
                    return new AvroSchemaConverter.SchemaType((DataType)NullType$.MODULE$, true);
                }
                if (Schema.Type.RECORD.equals(type)) {
                    if (existingRecordNames.contains((Object)avroSchema.getFullName())) {
                        throw new IncompatibleSchemaException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(195).append("\n                                                   |Found recursive reference in Avro schema, which can not be processed by Spark:\n                                                   |").append(avroSchema.toString(true)).append("\n          ").toString())), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    }
                    Set newRecordNames = (Set)existingRecordNames.$plus((Object)avroSchema.getFullName());
                    Seq fields = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getFields()).asScala().map((Function1 & Serializable)f -> {
                        AvroSchemaConverter.SchemaType schemaType = MODULE$.toSqlTypeHelper(f.schema(), (Set<String>)newRecordNames);
                        return new StructField(f.name(), schemaType.dataType(), schemaType.nullable(), StructField$.MODULE$.apply$default$4());
                    })).toSeq();
                    return new AvroSchemaConverter.SchemaType((DataType)StructType$.MODULE$.apply(fields), false);
                }
                if (Schema.Type.ARRAY.equals(type)) {
                    AvroSchemaConverter.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getElementType(), existingRecordNames);
                    return new AvroSchemaConverter.SchemaType((DataType)new ArrayType(schemaType.dataType(), schemaType.nullable()), false);
                }
                if (Schema.Type.MAP.equals(type)) {
                    AvroSchemaConverter.SchemaType schemaType = this.toSqlTypeHelper(avroSchema.getValueType(), existingRecordNames);
                    return new AvroSchemaConverter.SchemaType((DataType)new MapType((DataType)StringType$.MODULE$, schemaType.dataType(), schemaType.nullable()), false);
                }
                if (!Schema.Type.UNION.equals(type)) break block23;
                if (CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaConverter$.$anonfun$toSqlTypeHelper$2(x$1)))) {
                    Buffer remainingUnionTypes = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AvroSchemaConverter$.$anonfun$toSqlTypeHelper$3(x$2)));
                    if (remainingUnionTypes.size() == 1) {
                        AvroSchemaConverter.SchemaType qual$1 = this.toSqlTypeHelper((Schema)remainingUnionTypes.head(), existingRecordNames);
                        boolean x$12 = true;
                        DataType x$22 = qual$1.copy$default$1();
                        return qual$1.copy(x$22, true);
                    }
                    AvroSchemaConverter.SchemaType qual$2 = this.toSqlTypeHelper(Schema.createUnion((List)CollectionConverters$.MODULE$.BufferHasAsJava(remainingUnionTypes).asJava()), existingRecordNames);
                    boolean x$32 = true;
                    DataType x$4 = qual$2.copy$default$1();
                    return qual$2.copy(x$4, true);
                }
                bl = false;
                seq = null;
                Buffer buffer = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().map((Function1 & Serializable)x$3 -> x$3.getType());
                if (!(buffer instanceof Seq)) break;
                bl = true;
                seq = (Seq)buffer;
                SeqOps seqOps3 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps3) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps3), 1) != 0) break;
                avroSchema = (Schema)avroSchema.getTypes().get(0);
            }
            if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps2 = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 2) == 0) {
                Object t1 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 0);
                Object t2 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps2), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG})))) {
                    return new AvroSchemaConverter.SchemaType((DataType)LongType$.MODULE$, false);
                }
            }
            if (bl && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2) == 0) {
                Object t1 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
                Object t2 = SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
                if (BoxesRunTime.equals((Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{t1, t2})), (Object)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE})))) {
                    return new AvroSchemaConverter.SchemaType((DataType)DoubleType$.MODULE$, false);
                }
            }
            Seq fields = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(avroSchema.getTypes()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Schema s = (Schema)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    AvroSchemaConverter.SchemaType schemaType = MODULE$.toSqlTypeHelper(s, existingRecordNames);
                    return new StructField(new StringBuilder(6).append("member").append(i).toString(), schemaType.dataType(), true, StructField$.MODULE$.apply$default$4());
                }
                throw new MatchError((Object)tuple2);
            })).toSeq();
            return new AvroSchemaConverter.SchemaType((DataType)StructType$.MODULE$.apply(fields), false);
        }
        throw new IncompatibleSchemaException(new StringBuilder(17).append("Unsupported type ").append(type).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    /*
     * Unable to fully structure code
     */
    public Schema toAvroType(DataType catalystType, boolean nullable, String recordName, String nameSpace) {
        block10: {
            block22: {
                block21: {
                    block19: {
                        block20: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block9: {
                                                                builder = SchemaBuilder.builder();
                                                                var10_6 = catalystType;
                                                                if (!BooleanType$.MODULE$.equals(var10_6)) break block9;
                                                                v0 = (Schema)builder.booleanType();
                                                                break block10;
                                                            }
                                                            if (!(ByteType$.MODULE$.equals(var10_6) != false ? true : (ShortType$.MODULE$.equals(var10_6) != false ? true : IntegerType$.MODULE$.equals(var10_6) != false))) break block11;
                                                            v0 = (Schema)builder.intType();
                                                            break block10;
                                                        }
                                                        if (!LongType$.MODULE$.equals(var10_6)) break block12;
                                                        v0 = (Schema)builder.longType();
                                                        break block10;
                                                    }
                                                    if (!DateType$.MODULE$.equals(var10_6)) break block13;
                                                    v0 = LogicalTypes.date().addToSchema((Schema)builder.intType());
                                                    break block10;
                                                }
                                                if (!TimestampType$.MODULE$.equals(var10_6)) break block14;
                                                v0 = LogicalTypes.timestampMicros().addToSchema((Schema)builder.longType());
                                                break block10;
                                            }
                                            if (!FloatType$.MODULE$.equals(var10_6)) break block15;
                                            v0 = (Schema)builder.floatType();
                                            break block10;
                                        }
                                        if (!DoubleType$.MODULE$.equals(var10_6)) break block16;
                                        v0 = (Schema)builder.doubleType();
                                        break block10;
                                    }
                                    if (!StringType$.MODULE$.equals(var10_6)) break block17;
                                    v0 = (Schema)builder.stringType();
                                    break block10;
                                }
                                if (!NullType$.MODULE$.equals(var10_6)) break block18;
                                v0 = (Schema)builder.nullType();
                                break block10;
                            }
                            if (!(var10_6 instanceof DecimalType)) break block19;
                            var11_7 = (DecimalType)var10_6;
                            avroType = LogicalTypes.decimal((int)var11_7.precision(), (int)var11_7.scale());
                            fixedSize = Decimal$.MODULE$.minBytesForPrecision()[var11_7.precision()];
                            var15_10 = nameSpace;
                            switch (var15_10 == null ? 0 : var15_10.hashCode()) {
                                case 0: {
                                    if (!"".equals(var15_10)) break;
                                    v1 = new StringBuilder(6).append(recordName).append(".fixed").toString();
                                    break block20;
                                }
                            }
                            v1 = new StringBuilder(7).append(nameSpace).append(".").append(recordName).append(".fixed").toString();
                        }
                        name = v1;
                        v0 = avroType.addToSchema((Schema)SchemaBuilder.fixed((String)name).size(fixedSize));
                        break block10;
                    }
                    if (!BinaryType$.MODULE$.equals(var10_6)) break block21;
                    v0 = (Schema)builder.bytesType();
                    break block10;
                }
                if (!(var10_6 instanceof ArrayType)) break block22;
                var16_12 = (ArrayType)var10_6;
                et = var16_12.elementType();
                containsNull = var16_12.containsNull();
                v0 = (Schema)builder.array().items(this.toAvroType(et, containsNull, recordName, nameSpace));
                break block10;
            }
            if (!(var10_6 instanceof MapType)) ** GOTO lbl-1000
            var19_15 = (MapType)var10_6;
            var20_16 = var19_15.keyType();
            vt = var19_15.valueType();
            valueContainsNull = var19_15.valueContainsNull();
            if (StringType$.MODULE$.equals(var20_16)) {
                v0 = (Schema)builder.map().values(this.toAvroType(vt, valueContainsNull, recordName, nameSpace));
            } else if (var10_6 instanceof StructType) {
                var23_19 = (StructType)var10_6;
                v2 = nameSpace;
                var25_20 = "";
                childNameSpace = (v2 == null ? var25_20 != null : v2.equals(var25_20) == false) ? new StringBuilder(1).append(nameSpace).append(".").append(recordName).toString() : recordName;
                fieldsAssembler = ((SchemaBuilder.RecordBuilder)builder.record(recordName).namespace(nameSpace)).fields();
                var23_19.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$toAvroType$1(java.lang.String org.apache.avro.SchemaBuilder$FieldAssembler org.apache.spark.sql.types.StructField ), (Lorg/apache/spark/sql/types/StructField;)Lorg/apache/avro/SchemaBuilder$FieldAssembler;)((String)childNameSpace, (SchemaBuilder.FieldAssembler)fieldsAssembler));
                v0 = (Schema)fieldsAssembler.endRecord();
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(var10_6).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        schema = v0;
        if (nullable) {
            v3 = catalystType;
            var27_24 = NullType$.MODULE$;
            if (v3 == null ? var27_24 != null : v3.equals(var27_24) == false) {
                return Schema.createUnion((Schema[])new Schema[]{this.nullSchema(), schema});
            }
        }
        return schema;
    }

    public boolean toAvroType$default$2() {
        return false;
    }

    public String toAvroType$default$3() {
        return "topLevelRecord";
    }

    public String toAvroType$default$4() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$2(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$toSqlTypeHelper$3(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ SchemaBuilder.FieldAssembler $anonfun$toAvroType$1(String childNameSpace$1, SchemaBuilder.FieldAssembler fieldsAssembler$1, StructField f) {
        Schema fieldAvroType = MODULE$.toAvroType(f.dataType(), f.nullable(), f.name(), childNameSpace$1);
        SchemaBuilder.GenericDefault field = fieldsAssembler$1.name(f.name()).type(fieldAvroType);
        if (f.nullable()) {
            return field.withDefault(null);
        }
        return field.noDefault();
    }

    private AvroSchemaConverter$() {
    }
}

