/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.confluent.avro;

import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.confluent.ConfluentClient;
import org.apache.spark.sql.confluent.avro.AvroSchemaConverter$;
import org.apache.spark.sql.confluent.avro.ConfluentAvroConnector$;
import org.apache.spark.sql.confluent.avro.ConfluentAvroDataToCatalyst$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t\u0015f\u0001B\u0017/\u0001nB\u0001\"\u0017\u0001\u0003\u0016\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0012)A\u00057\"Aq\f\u0001BK\u0002\u0013\u0005\u0001\r\u0003\u0005j\u0001\tE\t\u0015!\u0003b\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002\u0003?\u0001\u0005#\u0005\u000b\u0011\u00027\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!Q\u0011q\u0004\u0001\t\u0006\u0004%I!!\t\t\u0015\u0005-\u0002\u0001#b\u0001\n\u0003\ni\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u0013\u0005}\u0002A1A\u0005\n\u0005\u0005\u0003\u0002CA7\u0001\u0001\u0006I!a\u0011\t\u0013\u0005=\u0004A1A\u0005\n\u0005E\u0004\u0002CA@\u0001\u0001\u0006I!a\u001d\t\u0017\u0005\u0005\u0005\u00011AA\u0002\u0013%\u00111\u0011\u0005\f\u0003\u001f\u0003\u0001\u0019!a\u0001\n\u0013\t\t\nC\u0006\u0002\u001e\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0005bCAP\u0001\u0001\u0007\t\u0019!C\u0005\u0003CC1\"a)\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002&\"Y\u0011\u0011\u0016\u0001A\u0002\u0003\u0005\u000b\u0015BA4\u0011\u001d\tY\u000b\u0001C!\u0003[Ca!a-\u0001\t\u0003\u0002\u0007bBA[\u0001\u0011E\u0013q\u0017\u0005\b\u0003'\u0004A\u0011AAk\u0011\u001d\ti\u000f\u0001C)\u0003_D\u0011\"!>\u0001\u0003\u0003%\t!a>\t\u0013\u0005}\b!%A\u0005\u0002\t\u0005\u0001\"\u0003B\f\u0001E\u0005I\u0011\u0001B\r\u0011%\u0011i\u0002AI\u0001\n\u0003\u0011y\u0002C\u0005\u0003$\u0001\t\t\u0011\"\u0011\u0003&!I!Q\u0007\u0001\u0002\u0002\u0013\u0005!q\u0007\u0005\n\u0005s\u0001\u0011\u0011!C\u0001\u0005wA\u0011Ba\u0010\u0001\u0003\u0003%\tE!\u0011\t\u0013\t-\u0003!!A\u0005\u0002\t5\u0003\"\u0003B)\u0001\u0005\u0005I\u0011\tB*\u0011%\u00119\u0006AA\u0001\n\u0003\u0012IfB\u0005\u0003^9\n\t\u0011#\u0001\u0003`\u0019AQFLA\u0001\u0012\u0003\u0011\t\u0007\u0003\u0004~O\u0011\u0005!q\u000f\u0005\n\u0005s:\u0013\u0011!C#\u0005wB\u0011B! (\u0003\u0003%\tIa \t\u0013\t\u001du%!A\u0005\u0002\n%\u0005\"\u0003BNO\u0005\u0005I\u0011\u0002BO\u0005m\u0019uN\u001c4mk\u0016tG/\u0011<s_\u0012\u000bG/\u0019+p\u0007\u0006$\u0018\r\\=ti*\u0011q\u0006M\u0001\u0005CZ\u0014xN\u0003\u00022e\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003gQ\n1a]9m\u0015\t)d'A\u0003ta\u0006\u00148N\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<7\u0001A\n\u0006\u0001q\"u)\u0014\t\u0003{\tk\u0011A\u0010\u0006\u0003\u007f\u0001\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011IM\u0001\tG\u0006$\u0018\r\\=ti&\u00111I\u0010\u0002\u0010+:\f'/_#yaJ,7o]5p]B\u0011Q(R\u0005\u0003\rz\u0012\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\tA5*D\u0001J\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u0014,\u000f\u0005=#fB\u0001)T\u001b\u0005\t&B\u0001*;\u0003\u0019a$o\\8u}%\t!*\u0003\u0002V\u0013\u00069\u0001/Y2lC\u001e,\u0017BA,Y\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t)\u0016*A\u0003dQ&dG-F\u0001\\!\tiD,\u0003\u0002^}\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u001d\u0019XO\u00196fGR,\u0012!\u0019\t\u0003E\u001at!a\u00193\u0011\u0005AK\u0015BA3J\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015L\u0015\u0001C:vE*,7\r\u001e\u0011\u0002\u001f\r|gN\u001a7vK:$\b*\u001a7qKJ,\u0012\u0001\u001c\t\u0004[:\u0004X\"\u0001\u0019\n\u0005=\u0004$aD\"p]\u001adW/\u001a8u\u00072LWM\u001c;\u0011\u0005ETX\"\u0001:\u000b\u0005=\u001a(B\u0001;v\u00039\u00198\r[3nCJ,w-[:uefT!A^<\u0002\u000b-\fgm[1\u000b\u0005EB(\"A=\u0002\u0005%|\u0017BA>s\u0005)\teO]8TG\",W.Y\u0001\u0011G>tg\r\\;f]RDU\r\u001c9fe\u0002\na\u0001P5oSRtDcB@\u0002\u0004\u0005\u0015\u0011q\u0001\t\u0004\u0003\u0003\u0001Q\"\u0001\u0018\t\u000be;\u0001\u0019A.\t\u000b};\u0001\u0019A1\t\u000b)<\u0001\u0019\u00017\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002\u000eA)a*a\u0004\u0002\u0014%\u0019\u0011\u0011\u0003-\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIBM\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\t9B\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006i1/\u001e2kK\u000e$8k\u00195f[\u0006,\u0012\u0001\u001d\u0015\u0004\u0013\u0005\u0015\u0002c\u0001%\u0002(%\u0019\u0011\u0011F%\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005=\u0002\u0003BA\u000b\u0003cIA!a\r\u0002\u0018\tAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\t\tI\u0004E\u0002I\u0003wI1!!\u0010J\u0005\u001d\u0011un\u001c7fC:\f1\"\u0019<s_J+\u0017\rZ3sgV\u0011\u00111\t\t\t\u0003\u000b\ny%a\u0015\u0002Z5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0004nkR\f'\r\\3\u000b\u0007\u00055\u0013*\u0001\u0006d_2dWm\u0019;j_:LA!!\u0015\u0002H\t\u0019Q*\u00199\u0011\u0007!\u000b)&C\u0002\u0002X%\u00131!\u00138u!\u0019\tY&a\u0019\u0002h5\u0011\u0011Q\f\u0006\u0005\u0003?\n\t'A\u0004hK:,'/[2\u000b\u0005=2\u0014\u0002BA3\u0003;\u0012!cR3oKJL7\rR1uk6\u0014V-\u00193feB\u0019\u0001*!\u001b\n\u0007\u0005-\u0014JA\u0002B]f\fA\"\u0019<s_J+\u0017\rZ3sg\u0002\nq#\u0019<s_J\u001a\u0006/\u0019:l\t\u0016\u001cXM]5bY&TXM]:\u0016\u0005\u0005M\u0004\u0003CA#\u0003\u001f\n\u0019&!\u001e\u0011\t\u0005]\u00141P\u0007\u0003\u0003sR!a\f\u001a\n\t\u0005u\u0014\u0011\u0010\u0002\u0011\u0003Z\u0014x\u000eR3tKJL\u0017\r\\5{KJ\f\u0001$\u0019<s_J\u001a\u0006/\u0019:l\t\u0016\u001cXM]5bY&TXM]:!\u0003E\tgO]8CS:\f'/\u001f#fG>$WM]\u000b\u0003\u0003\u000b\u0003B!a\"\u0002\f6\u0011\u0011\u0011\u0012\u0006\u0004s\u0006\u0005\u0014\u0002BAG\u0003\u0013\u0013QBQ5oCJLH)Z2pI\u0016\u0014\u0018!F1we>\u0014\u0015N\\1ss\u0012+7m\u001c3fe~#S-\u001d\u000b\u0005\u0003'\u000bI\nE\u0002I\u0003+K1!a&J\u0005\u0011)f.\u001b;\t\u0013\u0005m\u0015#!AA\u0002\u0005\u0015\u0015a\u0001=%c\u0005\u0011\u0012M\u001e:p\u0005&t\u0017M]=EK\u000e|G-\u001a:!\u00039\tgO]8HK:,'/[2Ng\u001e,\"!a\u001a\u0002%\u00054(o\\$f]\u0016\u0014\u0018nY'tO~#S-\u001d\u000b\u0005\u0003'\u000b9\u000bC\u0005\u0002\u001cR\t\t\u00111\u0001\u0002h\u0005y\u0011M\u001e:p\u000f\u0016tWM]5d\u001bN<\u0007%\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0003\u0002h\u0005=\u0006bBAY-\u0001\u0007\u0011qM\u0001\u0006S:\u0004X\u000f^\u0001\u000baJ,G\u000f^=OC6,\u0017!\u00033p\u000f\u0016t7i\u001c3f)\u0019\tI,!2\u0002PB!\u00111XAa\u001b\t\tiLC\u0002\u0002@z\nqaY8eK\u001e,g.\u0003\u0003\u0002D\u0006u&\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005\u001d\u0007\u00041\u0001\u0002J\u0006\u00191\r\u001e=\u0011\t\u0005m\u00161Z\u0005\u0005\u0003\u001b\fiL\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005E\u0007\u00041\u0001\u0002:\u0006\u0011QM^\u0001\u0012a\u0006\u00148/Z\"p]\u001adW/\u001a8u\u001bN<G\u0003BAl\u0003S\u0004r\u0001SAm\u0003'\ni.C\u0002\u0002\\&\u0013a\u0001V;qY\u0016\u0014\u0004#\u0002%\u0002`\u0006\r\u0018bAAq\u0013\n)\u0011I\u001d:bsB\u0019\u0001*!:\n\u0007\u0005\u001d\u0018J\u0001\u0003CsR,\u0007bBAv3\u0001\u0007\u0011Q\\\u0001\u0004[N<\u0017\u0001F<ji\"tUm^\"iS2$\u0017J\u001c;fe:\fG\u000eF\u0002\u0000\u0003cDa!a=\u001b\u0001\u0004Y\u0016\u0001\u00038fo\u000eC\u0017\u000e\u001c3\u0002\t\r|\u0007/\u001f\u000b\b\u007f\u0006e\u00181`A\u007f\u0011\u001dI6\u0004%AA\u0002mCqaX\u000e\u0011\u0002\u0003\u0007\u0011\rC\u0004k7A\u0005\t\u0019\u00017\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0001\u0016\u00047\n\u00151F\u0001B\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tE\u0011*\u0001\u0006b]:|G/\u0019;j_:LAA!\u0006\u0003\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0004\u0016\u0004C\n\u0015\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005CQ3\u0001\u001cB\u0003\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\u0005\t\u0005\u0005S\u0011\u0019$\u0004\u0002\u0003,)!!Q\u0006B\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\tE\u0012\u0001\u00026bm\u0006L1a\u001aB\u0016\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d$Q\b\u0005\n\u00037\u000b\u0013\u0011!a\u0001\u0003'\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0007\u0002bA!\u0012\u0003H\u0005\u001dTBAA&\u0013\u0011\u0011I%a\u0013\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003s\u0011y\u0005C\u0005\u0002\u001c\u000e\n\t\u00111\u0001\u0002h\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00119C!\u0016\t\u0013\u0005mE%!AA\u0002\u0005M\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002:\tm\u0003\"CANK\u0005\u0005\t\u0019AA4\u0003m\u0019uN\u001c4mk\u0016tG/\u0011<s_\u0012\u000bG/\u0019+p\u0007\u0006$\u0018\r\\=tiB\u0019\u0011\u0011A\u0014\u0014\u000b\u001d\u0012\u0019Ga\u001c\u0011\u0011\t\u0015$1N.bY~l!Aa\u001a\u000b\u0007\t%\u0014*A\u0004sk:$\u0018.\\3\n\t\t5$q\r\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004\u0003\u0002B9\u0005kj!Aa\u001d\u000b\u0007e\u0014y#C\u0002X\u0005g\"\"Aa\u0018\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\n\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u0014\tIa!\u0003\u0006\")\u0011L\u000ba\u00017\")qL\u000ba\u0001C\")!N\u000ba\u0001Y\u00069QO\\1qa2LH\u0003\u0002BF\u0005/\u0003R\u0001\u0013BG\u0005#K1Aa$J\u0005\u0019y\u0005\u000f^5p]B1\u0001Ja%\\C2L1A!&J\u0005\u0019!V\u000f\u001d7fg!A!\u0011T\u0016\u0002\u0002\u0003\u0007q0A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa(\u0011\t\t%\"\u0011U\u0005\u0005\u0005G\u0013YC\u0001\u0004PE*,7\r\u001e")
public class ConfluentAvroDataToCatalyst
extends UnaryExpression
implements ExpectsInputTypes,
Serializable {
    private transient AvroSchema subjectSchema;
    private DataType dataType;
    private final Expression child;
    private final String subject;
    private final ConfluentClient<AvroSchema> confluentHelper;
    private final Map<Object, GenericDatumReader<Object>> avroReaders;
    private final Map<Object, AvroDeserializer> avro2SparkDeserializers;
    private BinaryDecoder avroBinaryDecoder;
    private Object avroGenericMsg;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, String, ConfluentClient<AvroSchema>>> unapply(ConfluentAvroDataToCatalyst x$0) {
        return ConfluentAvroDataToCatalyst$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, String, ConfluentClient<AvroSchema>>, ConfluentAvroDataToCatalyst> tupled() {
        return ConfluentAvroDataToCatalyst$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<String, Function1<ConfluentClient<AvroSchema>, ConfluentAvroDataToCatalyst>>> curried() {
        return ConfluentAvroDataToCatalyst$.MODULE$.curried();
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression child() {
        return this.child;
    }

    public String subject() {
        return this.subject;
    }

    public ConfluentClient<AvroSchema> confluentHelper() {
        return this.confluentHelper;
    }

    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    private AvroSchema subjectSchema$lzycompute() {
        ConfluentAvroDataToCatalyst confluentAvroDataToCatalyst = this;
        synchronized (confluentAvroDataToCatalyst) {
            if (!this.bitmap$trans$0) {
                this.subjectSchema = (AvroSchema)this.confluentHelper().getLatestSchemaFromConfluent(this.subject())._2();
                this.bitmap$trans$0 = true;
            }
        }
        return this.subjectSchema;
    }

    private AvroSchema subjectSchema() {
        if (!this.bitmap$trans$0) {
            return this.subjectSchema$lzycompute();
        }
        return this.subjectSchema;
    }

    private DataType dataType$lzycompute() {
        ConfluentAvroDataToCatalyst confluentAvroDataToCatalyst = this;
        synchronized (confluentAvroDataToCatalyst) {
            if (!this.bitmap$0) {
                this.dataType = AvroSchemaConverter$.MODULE$.toSqlType(this.subjectSchema().rawSchema()).dataType();
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    public DataType dataType() {
        if (!this.bitmap$0) {
            return this.dataType$lzycompute();
        }
        return this.dataType;
    }

    public boolean nullable() {
        return true;
    }

    private Map<Object, GenericDatumReader<Object>> avroReaders() {
        return this.avroReaders;
    }

    private Map<Object, AvroDeserializer> avro2SparkDeserializers() {
        return this.avro2SparkDeserializers;
    }

    private BinaryDecoder avroBinaryDecoder() {
        return this.avroBinaryDecoder;
    }

    private void avroBinaryDecoder_$eq(BinaryDecoder x$1) {
        this.avroBinaryDecoder = x$1;
    }

    private Object avroGenericMsg() {
        return this.avroGenericMsg;
    }

    private void avroGenericMsg_$eq(Object x$1) {
        this.avroGenericMsg = x$1;
    }

    public Object nullSafeEval(Object input) {
        byte[] binary = (byte[])input;
        Tuple2<Object, byte[]> tuple2 = this.parseConfluentMsg(binary);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int schemaId = tuple2._1$mcI$sp();
        byte[] avroMsg = (byte[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)schemaId), (Object)avroMsg);
        int schemaId2 = tuple22._1$mcI$sp();
        byte[] avroMsg2 = (byte[])tuple22._2();
        Tuple2<Object, AvroSchema> tuple23 = this.confluentHelper().getSchemaFromConfluent(schemaId2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        AvroSchema msgSchema = (AvroSchema)tuple23._2();
        AvroSchema msgSchema2 = msgSchema;
        this.avroBinaryDecoder_$eq(DecoderFactory.get().binaryDecoder(avroMsg2, 0, avroMsg2.length, this.avroBinaryDecoder()));
        GenericDatumReader avroReader = (GenericDatumReader)this.avroReaders().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)schemaId2), (Function0 & Serializable)() -> new GenericDatumReader(msgSchema2.rawSchema(), this.subjectSchema().rawSchema()));
        this.avroGenericMsg_$eq(avroReader.read(this.avroGenericMsg(), (Decoder)this.avroBinaryDecoder()));
        AvroDeserializer avro2SparkDeserializer = (AvroDeserializer)this.avro2SparkDeserializers().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)schemaId2), (Function0 & Serializable)() -> new AvroDeserializer(this.subjectSchema().rawSchema(), this.dataType(), SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED().toString()));
        return avro2SparkDeserializer.deserialize(this.avroGenericMsg()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String prettyName() {
        return "from_confluent_avro";
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String expr = ctx.addReferenceObj("this", (Object)this, ctx.addReferenceObj$default$3());
        return this.defineCodeGen(ctx, ev, (Function1 & Serializable)input -> new StringBuilder(17).append("(").append(CodeGenerator$.MODULE$.boxedType(this.dataType())).append(")").append(expr).append(".nullSafeEval(").append((String)input).append(")").toString());
    }

    public Tuple2<Object, byte[]> parseConfluentMsg(byte[] msg) {
        ByteBuffer msgBuffer = ByteBuffer.wrap(msg);
        byte magicByte = msgBuffer.get();
        Predef$.MODULE$.require(magicByte == ConfluentAvroConnector$.MODULE$.CONFLUENT_MAGIC_BYTE(), (Function0 & Serializable)() -> "Magic byte not present at start of confluent message!");
        int schemaId = msgBuffer.getInt();
        byte[] avroMsg = (byte[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.byteArrayOps(msg), msgBuffer.position(), msgBuffer.limit());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)schemaId), (Object)avroMsg);
    }

    public ConfluentAvroDataToCatalyst withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    public ConfluentAvroDataToCatalyst copy(Expression child, String subject, ConfluentClient<AvroSchema> confluentHelper) {
        return new ConfluentAvroDataToCatalyst(child, subject, confluentHelper);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public String copy$default$2() {
        return this.subject();
    }

    public ConfluentClient<AvroSchema> copy$default$3() {
        return this.confluentHelper();
    }

    public String productPrefix() {
        return "ConfluentAvroDataToCatalyst";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.subject();
            }
            case 2: {
                return this.confluentHelper();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ConfluentAvroDataToCatalyst;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "subject";
            }
            case 2: {
                return "confluentHelper";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ConfluentAvroDataToCatalyst)) return false;
        boolean bl = true;
        if (!bl) return false;
        ConfluentAvroDataToCatalyst confluentAvroDataToCatalyst = (ConfluentAvroDataToCatalyst)x$1;
        Expression expression = this.child();
        Expression expression2 = confluentAvroDataToCatalyst.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        String string = this.subject();
        String string2 = confluentAvroDataToCatalyst.subject();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        ConfluentClient<AvroSchema> confluentClient = this.confluentHelper();
        ConfluentClient<AvroSchema> confluentClient2 = confluentAvroDataToCatalyst.confluentHelper();
        if (confluentClient == null) {
            if (confluentClient2 != null) {
                return false;
            }
        } else if (!confluentClient.equals(confluentClient2)) return false;
        if (!confluentAvroDataToCatalyst.canEqual(this)) return false;
        return true;
    }

    public ConfluentAvroDataToCatalyst(Expression child, String subject, ConfluentClient<AvroSchema> confluentHelper) {
        this.child = child;
        this.subject = subject;
        this.confluentHelper = confluentHelper;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
        this.avroReaders = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.avro2SparkDeserializers = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

