/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.confluent.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.confluent.IncompatibleSchemaException;
import org.apache.spark.sql.confluent.IncompatibleSchemaException$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001B\u0007\u000f\u0001mA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005a!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003:\u0001\u0011\u0005!\bC\u0003A\u0001\u0011\u0005\u0011\tC\u0004H\u0001\t\u0007I\u0011\u0002%\t\r1\u0003\u0001\u0015!\u0003J\u000b\u0011i\u0005\u0001\u0002(\t\u0011q\u0003\u0001R1A\u0005\nuCQA\u001c\u0001\u0005\n=Dq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u00026\u0001!I!a\u000e\u0003!5K\u0018I\u001e:p'\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\b\u0011\u0003\u0011\tgO]8\u000b\u0005E\u0011\u0012!C2p]\u001adW/\u001a8u\u0015\t\u0019B#A\u0002tc2T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB1qC\u000eDWMC\u0001\u001a\u0003\ry'oZ\u0002\u0001'\r\u0001AD\t\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015\"\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u0011e>|GoQ1uC2L8\u000f\u001e+za\u0016\u0004\"AK\u0017\u000e\u0003-R!\u0001\f\n\u0002\u000bQL\b/Z:\n\u00059Z#\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0019I|w\u000e^!we>$\u0016\u0010]3\u0011\u0005E\u001aT\"\u0001\u001a\u000b\u0005=1\u0012B\u0001\u001b3\u0005\u0019\u00196\r[3nC\u0006Aa.\u001e7mC\ndW\r\u0005\u0002\u001eo%\u0011\u0001H\b\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q!1(\u0010 @!\ta\u0004!D\u0001\u000f\u0011\u0015AC\u00011\u0001*\u0011\u0015yC\u00011\u00011\u0011\u0015)D\u00011\u00017\u0003%\u0019XM]5bY&TX\r\u0006\u0002C\u000bB\u0011QdQ\u0005\u0003\tz\u00111!\u00118z\u0011\u00151U\u00011\u0001C\u00031\u0019\u0017\r^1msN$H)\u0019;b\u0003%\u0019wN\u001c<feR,'/F\u0001J!\u0011i\"J\u0011\"\n\u0005-s\"!\u0003$v]\u000e$\u0018n\u001c82\u0003)\u0019wN\u001c<feR,'\u000f\t\u0002\n\u0007>tg/\u001a:uKJ\u0004R!H(R3\nK!\u0001\u0015\u0010\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005Y\u0013\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005a\u001b&AE*qK\u000eL\u0017\r\\5{K\u0012<U\r\u001e;feN\u0004\"!\b.\n\u0005ms\"aA%oi\u0006\u0011B-Z2j[\u0006d7i\u001c8wKJ\u001c\u0018n\u001c8t+\u0005q\u0006CA0l\u001d\t\u0001\u0017N\u0004\u0002bQ:\u0011!m\u001a\b\u0003G\u001al\u0011\u0001\u001a\u0006\u0003Kj\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005]A\u0012BA\b\u0017\u0013\tQ''A\u0006D_:4XM]:j_:\u001c\u0018B\u00017n\u0005E!UmY5nC2\u001cuN\u001c<feNLwN\u001c\u0006\u0003UJ\nAB\\3x\u0007>tg/\u001a:uKJ$B\u0001\u001d:umB\u0011\u0011\u000fC\u0007\u0002\u0001!)1O\u0003a\u0001S\u0005a1-\u0019;bYf\u001cH\u000fV=qK\")QO\u0003a\u0001a\u0005A\u0011M\u001e:p)f\u0004X\rC\u0003x\u0015\u0001\u0007\u00010A\u0005gS\u0016dGMT1nKB\u0011\u00110 \b\u0003un\u0004\"a\u0019\u0010\n\u0005qt\u0012A\u0002)sK\u0012,g-\u0003\u0002\u007f\u007f\n11\u000b\u001e:j]\u001eT!\u0001 \u0010\u0002%9,wo\u0015;sk\u000e$8i\u001c8wKJ$XM\u001d\u000b\t\u0003\u000b\t)#a\f\u00024A1QDSA\u0004\u0003\u001f\u0001B!!\u0003\u0002\f5\tQ+C\u0002\u0002\u000eU\u00131\"\u00138uKJt\u0017\r\u001c*poB!\u0011\u0011CA\u0010\u001d\u0011\t\u0019\"!\u0007\u000f\u0007\u0001\f)\"C\u0002\u0002\u0018I\nqaZ3oKJL7-\u0003\u0003\u0002\u001c\u0005u\u0011aC$f]\u0016\u0014\u0018n\u0019#bi\u0006T1!a\u00063\u0013\u0011\t\t#a\t\u0003\rI+7m\u001c:e\u0015\u0011\tY\"!\b\t\u000f\u0005\u001d2\u00021\u0001\u0002*\u0005q1-\u0019;bYf\u001cHo\u0015;sk\u000e$\bc\u0001\u0016\u0002,%\u0019\u0011QF\u0016\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004\u00022-\u0001\r\u0001M\u0001\u000bCZ\u0014xn\u0015;sk\u000e$\b\"B<\f\u0001\u0004A\u0018a\u0005:fg>dg/\u001a(vY2\f'\r\\3UsB,Gc\u0002\u0019\u0002:\u0005m\u0012Q\b\u0005\u0006k2\u0001\r\u0001\r\u0005\u0006g2\u0001\r!\u000b\u0005\u0006o2\u0001\r\u0001\u001f")
public class MyAvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final boolean nullable;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        MyAvroSerializer myAvroSerializer = this;
        synchronized (myAvroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        if (!this.bitmap$0) {
            return this.decimalConversions$lzycompute();
        }
        return this.decimalConversions;
    }

    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType, String fieldName) {
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = CollectionConverters$.MODULE$.ListHasAsScala(avroType.getEnumSymbols()).asScala().toSet();
                return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$11(enumSymbols, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$13(size, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)MyAvroSerializer.$anonfun$newConverter$16(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                if (logicalType == null) {
                    return (Function2 & Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)MyAvroSerializer.$anonfun$newConverter$18(getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot convert Catalyst Timestamp type to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), et, fieldName), fieldName);
                    return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$19(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType, fieldName);
                    int numFields = structType.length();
                    return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$20(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                if (Schema.Type.MAP.equals(type)) {
                    DataType dataType2 = kt;
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null)) {
                        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), vt, fieldName), fieldName);
                        return (Function2 & Serializable)(getter, ordinal) -> MyAvroSerializer.$anonfun$newConverter$21(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        throw new IncompatibleSchemaException(new StringBuilder(47).append("(").append(fieldName).append(") Cannot convert Catalyst type ").append(catalystType).append(" to ").append("Avro type ").append(avroType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct, String fieldName) {
        Schema.Type type = avroStruct.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if ((type != null ? !type.equals(type2) : type2 != null) || avroStruct.getFields().size() != catalystStruct.length()) {
            throw new IncompatibleSchemaException(new StringBuilder(47).append("(").append(fieldName).append(") Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append("Avro type ").append(avroStruct).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq fieldConverters = (Seq)((IterableOps)catalystStruct.zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(avroStruct.getFields()).asScala())).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField f1 = (StructField)tuple2._1();
                Schema.Field f2 = (Schema.Field)tuple2._2();
                return this.newConverter(f1.dataType(), this.resolveNullableType(f2.schema(), f1.dataType(), f1.name()), f1.name());
            }
            throw new MatchError((Object)tuple2);
        });
        int numFields = catalystStruct.length();
        return (Function1 & Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(i, null);
                    continue;
                }
                result.put(i, ((Function2)fieldConverters.apply(i)).apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    private Schema resolveNullableType(Schema avroType, DataType catalystType, String fieldName) {
        block1: {
            Schema.Type type = avroType.getType();
            Schema.Type type2 = Schema.Type.UNION;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                Buffer fields = CollectionConverters$.MODULE$.ListHasAsScala(avroType.getTypes()).asScala();
                Predef$.MODULE$.assert(fields.length() == 2);
                DataType dataType = catalystType;
                NullType$ nullType$ = NullType$.MODULE$;
                Buffer actualType = !(dataType != null ? !dataType.equals(nullType$) : nullType$ != null) ? (Buffer)fields.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MyAvroSerializer.$anonfun$resolveNullableType$1(x$1))) : (Buffer)fields.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MyAvroSerializer.$anonfun$resolveNullableType$2(x$2)));
                Predef$.MODULE$.assert(actualType.length() == 1);
                return (Schema)actualType.head();
            }
            if (!this.nullable) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(148).append("(").append(fieldName).append(") Writing avro files with non-nullable avro schema with nullable catalyst ").append("schema will throw runtime exception if there is a record with null value.").toString());
        }
        return avroType;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(MyAvroSerializer $this, DecimalType x35$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x35$1.precision(), x35$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x35$1.precision(), (int)x35$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(MyAvroSerializer $this, DecimalType x38$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x38$1.precision(), x38$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x38$1.precision(), (int)x38$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(49).append("Cannot write \"").append(data).append("\" since it's not defined in enum \"").append(enumSymbols$1.mkString("\", \"")).append("\"").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(60).append("Cannot write ").append(data.length).append(" ").append((Object)(data.length > 1 ? "bytes" : "byte")).append(" of ").append("binary data into FIXED Type with size of ").append(size$1).append(" ").append((Object)(size$1 > 1 ? "bytes" : "byte")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$16(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ long $anonfun$newConverter$18(SpecializedGetters getter, int ordinal) {
        return getter.getLong(ordinal) / 1000L;
    }

    public static final /* synthetic */ java.util.List $anonfun$newConverter$19(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$20(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$21(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$1(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$resolveNullableType$2(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public MyAvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        Function1 & Serializable intersect;
        this.nullable = nullable;
        Logging.$init$((Logging)this);
        Schema actualAvroType = this.resolveNullableType(rootAvroType, rootCatalystType, "root");
        DataType dataType = rootCatalystType;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            intersect = this.newStructConverter(structType, actualAvroType, "root");
        } else {
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)new .colon.colon((Object)rootCatalystType, (List)Nil$.MODULE$));
            Function2<SpecializedGetters, Object, Object> converter = this.newConverter(rootCatalystType, actualAvroType, "root");
            intersect = (Function1 & Serializable)data -> {
                tmpRow.update(0, data);
                return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
            };
        }
        Function1 & Serializable baseConverter = intersect;
        this.converter = nullable ? (Function1 & Serializable)data -> {
            if (data == null) {
                return null;
            }
            return baseConverter.apply(data);
        } : baseConverter;
    }
}

