/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.confluent.json;

import java.io.Serializable;
import org.apache.spark.sql.confluent.IncompatibleSchemaException;
import org.apache.spark.sql.confluent.IncompatibleSchemaException$;
import org.apache.spark.sql.confluent.json.JSchemaArray;
import org.apache.spark.sql.confluent.json.JSchemaBasicType;
import org.apache.spark.sql.confluent.json.JSchemaBasicType$;
import org.apache.spark.sql.confluent.json.JSchemaMap;
import org.apache.spark.sql.confluent.json.JSchemaObject;
import org.apache.spark.sql.confluent.json.JSchemaObject$;
import org.apache.spark.sql.confluent.json.JsonSchemaConverter$;
import org.apache.spark.sql.confluent.json.JsonSchemaEntry;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.json4s.JsonAST;
import org.json4s.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkToJsonSchemaConverter$ {
    public static final SparkToJsonSchemaConverter$ MODULE$ = new SparkToJsonSchemaConverter$();

    public JsonAST.JObject convert(StructType schema) {
        JsonAST.JObject jsonSchema = this.toJSchemaType((DataType)schema).toJson();
        Tuple2 tuple2 = JsonAST.JField$.MODULE$.apply("$schema", (JsonAST.JValue)package$.MODULE$.JString().apply("http://json-schema.org/draft-04/schema#"));
        return package$.MODULE$.JObject().apply((List)jsonSchema.obj().$plus$colon((Object)tuple2));
    }

    private JsonSchemaEntry toJSchemaType(DataType catalystType) {
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType et = arrayType.elementType();
            return new JSchemaArray(this.toJSchemaType(et));
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType dataType2 = mapType.keyType();
            DataType vt = mapType.valueType();
            if (StringType$.MODULE$.equals(dataType2)) {
                return new JSchemaMap(this.toJSchemaType(vt));
            }
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new JSchemaObject((Map<String, JsonSchemaEntry>)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)f -> new Tuple2((Object)f.name(), (Object)MODULE$.toJSchemaType(f.dataType())), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Seq<String>)((Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])structType.fields()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nullable())))).map((Function1 & Serializable)x$2 -> x$2.name())), JSchemaObject$.MODULE$.apply$default$3());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            if (decimalType.scale() == 0) {
                return new JSchemaBasicType("integer");
            }
        }
        if (bl) {
            return new JSchemaBasicType("number");
        }
        return (JsonSchemaEntry)JsonSchemaConverter$.MODULE$.SparkToJsonTypeMap().get((Object)dataType).map((Function1)JSchemaBasicType$.MODULE$).getOrElse((Function0 & Serializable)() -> {
            throw new IncompatibleSchemaException(new StringBuilder(17).append("Unexpected type ").append(dataType).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        });
    }

    private SparkToJsonSchemaConverter$() {
    }
}

