/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.xml.XsdSchemaConverter;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;

@Experimental
public final class XsdSchemaConverter$ {
    public static final XsdSchemaConverter$ MODULE$ = new XsdSchemaConverter$();

    @Experimental
    public StructType read(File xsdFile, int maxRecursion) {
        XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
        xmlSchemaCollection.setBaseUri(xsdFile.getParent());
        XmlSchema xmlSchema = xmlSchemaCollection.read((Reader)new InputStreamReader((InputStream)new FileInputStream(xsdFile), StandardCharsets.UTF_8));
        return new XsdSchemaConverter(xmlSchema, maxRecursion).getStructType();
    }

    @Experimental
    public StructType read(Path xsdFile, int maxRecursion) {
        return this.read(xsdFile.toFile(), maxRecursion);
    }

    @Experimental
    public StructType read(String xsdString, int maxRecursion) {
        XmlSchema xmlSchema = new XmlSchemaCollection().read((Reader)new StringReader(xsdString));
        return new XsdSchemaConverter(xmlSchema, maxRecursion).getStructType();
    }

    private XsdSchemaConverter$() {
    }
}

