/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import io.netty.channel.unix.Errors;
import java.io.Serializable;
import java.net.BindException;
import org.slf4j.Logger;
import org.sparkproject.jetty.util.MultiException;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class PortUtils$ {
    public static final PortUtils$ MODULE$ = new PortUtils$();

    public int userPort(int base, int offset) {
        return (base + offset - 1024) % 64512 + 1024;
    }

    public int startOnPort(Function1<Object, Object> startServer, String serverName, int startPort, int maxRetries, Logger logger) {
        Object object = new Object();
        try {
            Predef$.MODULE$.require(1024 <= startPort && startPort < 65536, (Function0 & Serializable)() -> "startPort should be between 1024 and 65535 (inclusive)");
            Predef$.MODULE$.require(maxRetries >= 0, (Function0 & Serializable)() -> "maxRetries has to be >= 0");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), maxRetries + 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
                int tryPort = MODULE$.userPort(startPort, offset);
                try {
                    int port = startServer.apply$mcII$sp(tryPort);
                    logger.info(new StringBuilder(38).append("Successfully started server ").append(serverName).append(" on port ").append(port).append(".").toString());
                    throw new NonLocalReturnControl.mcI.sp(object, port);
                }
                catch (Throwable throwable) {
                    Exception exception;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof Exception && MODULE$.isBindCollision(exception = (Exception)throwable2)) {
                        if (offset >= maxRetries) {
                            String exceptionMessage = new StringBuilder(49).append(exception.getMessage()).append(": Server ").append(serverName).append(" failed after ").append(maxRetries).append(" retries (starting from ").append(startPort).append(")!").toString();
                            BindException exception2 = new BindException(exceptionMessage);
                            exception2.setStackTrace(exception.getStackTrace());
                            throw exception2;
                        }
                    } else {
                        throw throwable;
                    }
                    logger.warn(new StringBuilder(50).append("Server ").append(serverName).append(" could not bind on port ").append(tryPort).append(". Attempting port ").append(tryPort + 1).append(".").toString());
                    return;
                }
            });
            throw new IllegalStateException(new StringBuilder(32).append("Failed to start server ").append(serverName).append(" on port ").append(startPort).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return ex.value$mcI$sp();
        }
    }

    public boolean isBindCollision(Throwable exception2) {
        while (true) {
            Throwable throwable;
            if ((throwable = exception2) instanceof BindException) {
                BindException bindException = (BindException)throwable;
                if (bindException.getMessage() != null) {
                    return true;
                }
                exception2 = bindException.getCause();
                continue;
            }
            if (throwable instanceof MultiException) {
                MultiException multiException = (MultiException)throwable;
                return CollectionConverters$.MODULE$.ListHasAsScala(multiException.getThrowables()).asScala().exists((Function1 & Serializable)exception -> BoxesRunTime.boxToBoolean((boolean)PortUtils$.MODULE$.isBindCollision(exception)));
            }
            if (throwable instanceof Errors.NativeIoException) {
                Errors.NativeIoException nativeIoException = (Errors.NativeIoException)throwable;
                if (nativeIoException.getMessage() == null || !nativeIoException.getMessage().startsWith("bind() failed: ")) {
                    exception2 = nativeIoException.getCause();
                    continue;
                }
                return true;
            }
            if (!(throwable instanceof Exception)) break;
            Exception exception3 = (Exception)throwable;
            exception2 = exception3.getCause();
        }
        return false;
    }

    private PortUtils$() {
    }
}

