/*
 * Decompiled with CFR 0.152.
 */
package com.bytex.snamp.supervision.discovery.http;

import com.bytex.snamp.Acceptor;
import com.bytex.snamp.internal.Utils;
import com.bytex.snamp.supervision.SupervisorClient;
import com.bytex.snamp.supervision.discovery.InvalidResourceGroupException;
import com.bytex.snamp.supervision.discovery.ResourceDiscoveryException;
import com.bytex.snamp.supervision.discovery.ResourceDiscoveryService;
import com.bytex.snamp.supervision.discovery.ResourceGroupNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;
import org.osgi.framework.BundleContext;

@Path(value="/{groupName}")
public final class RESTDiscoveryService {
    private static final int NOT_IMPLEMENTED_STATUS = 501;

    private BundleContext getBundleContext() {
        return Utils.getBundleContextOfObject((Object)this);
    }

    private static WebApplicationException unsupervisedGroup(String groupName) {
        return new WebApplicationException(Response.status((int)501).entity((Object)String.format("Supervisor is not assigned for group %s", groupName)).build());
    }

    private static WebApplicationException unsupportedDiscovery(String groupName) {
        return new WebApplicationException(Response.status((int)501).entity((Object)String.format("Supervisor for group %s doesn't support discovery service", groupName)).build());
    }

    private <E extends Throwable> void withDiscoveryService(String groupName, Acceptor<? super ResourceDiscoveryService, E> acceptor) throws E {
        Optional clientRef = SupervisorClient.tryCreate((BundleContext)this.getBundleContext(), (String)groupName);
        if (clientRef.isPresent()) {
            try (SupervisorClient client = (SupervisorClient)clientRef.get();){
                ResourceDiscoveryService discoveryService = (ResourceDiscoveryService)client.queryObject(ResourceDiscoveryService.class).orElseThrow(() -> RESTDiscoveryService.unsupportedDiscovery(groupName));
                acceptor.accept((Object)discoveryService);
            }
        } else {
            throw RESTDiscoveryService.unsupervisedGroup(groupName);
        }
    }

    private static void registerResource(ResourceDiscoveryService discoveryService, String resourceName, ResourceAnnouncement announcement) throws ResourceDiscoveryException {
        try {
            discoveryService.registerResource(resourceName, announcement.getConnectionString(), announcement.getParameters());
        }
        catch (InvalidResourceGroupException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (ResourceGroupNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @POST
    @Path(value="/{resourceName}")
    @Consumes(value={"application/json"})
    public Response registerResource(@PathParam(value="groupName") String groupName, @PathParam(value="resourceName") String resourceName, ResourceAnnouncement announcement) throws ResourceDiscoveryException {
        this.withDiscoveryService(groupName, discoveryService -> RESTDiscoveryService.registerResource(discoveryService, resourceName, announcement));
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    private static void removeResource(ResourceDiscoveryService discoveryService, String resourceName) throws ResourceDiscoveryException {
        try {
            if (!discoveryService.removeResource(resourceName)) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("Resource %s doesn't exist", resourceName)).build());
            }
        }
        catch (InvalidResourceGroupException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
        catch (ResourceGroupNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
    }

    @DELETE
    @Path(value="/{resourceName}")
    public Response removeResource(@PathParam(value="groupName") String groupName, @PathParam(value="resourceName") String resourceName) throws ResourceDiscoveryException {
        this.withDiscoveryService(groupName, discoveryService -> RESTDiscoveryService.removeResource(discoveryService, resourceName));
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @DELETE
    public Response removeAllResources(@PathParam(value="groupName") String groupName) throws ResourceDiscoveryException {
        this.withDiscoveryService(groupName, ResourceDiscoveryService::removeAllResources);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public static final class ResourceAnnouncement {
        private String connectionString = "";
        private final Map<String, String> parameters = new HashMap<String, String>();

        @JsonProperty(value="connectionString")
        public String getConnectionString() {
            return this.connectionString;
        }

        public void setConnectionString(@Nonnull String value) {
            if (value == null) {
                ResourceAnnouncement.$$$reportNull$$$0(0);
            }
            this.connectionString = value;
        }

        @JsonProperty(value="parameters")
        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public void setParameters(@Nonnull Map<String, String> value) {
            if (value == null) {
                ResourceAnnouncement.$$$reportNull$$$0(1);
            }
            this.parameters.clear();
            this.parameters.putAll(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "value";
            objectArray2[1] = "com/bytex/snamp/supervision/discovery/http/RESTDiscoveryService$ResourceAnnouncement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setConnectionString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @Nonnull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

