/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd;

import cacheperf.CachePerfClient;
import cacheperf.comparisons.gemfirexd.QueryPerfException;
import cacheperf.comparisons.gemfirexd.QueryPerfPrms;
import cacheperf.comparisons.gemfirexd.QueryPerfStats;
import cacheperf.comparisons.gemfirexd.QueryUtil;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheTransactionManager;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.control.RebalanceOperation;
import com.gemstone.gemfire.cache.control.ResourceManager;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.utils.ExecutionPlanUtils;
import hydra.BasePrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.gemfirexd.FabricServerDescription;
import hydra.gemfirexd.FabricServerHelper;
import hydra.gemfirexd.GfxdConfigPrms;
import hydra.gemfirexd.GfxdTestConfig;
import hydra.gemfirexd.LonerHelper;
import hydra.gemfirexd.NetworkServerHelper;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import objects.query.BaseQueryFactory;
import objects.query.GFEQueryFactory;
import objects.query.OQLQueryFactory;
import objects.query.QueryFactory;
import objects.query.QueryHelper;
import objects.query.QueryPrms;
import objects.query.SQLQueryFactory;

public class QueryPerfClient
extends CachePerfClient {
    protected static final boolean useExistingData = QueryPerfPrms.useExistingData();
    protected static Map<String, List<Integer>> PrimaryBucketList;
    protected boolean logQueriesSetting;
    protected int queryAPI;
    protected QueryFactory queryFactory;
    protected String queryObjectType;
    protected int txIsolation;
    protected long queryPlanFrequency;
    protected int maxQueryPlanners;
    protected boolean queryPlanGenerationEnabled = false;
    protected static final int QUERIES = 6230814;
    protected static final int UPDATES = 6230815;
    protected static final int CREATES = 6230817;
    protected static final int DELETES = 6230818;
    protected static final String QUERY_NAME = "queries";
    protected static final String UPDATES_NAME = "updates";
    protected static final String CREATE_NAME = "creates";
    protected static final String DELETES_NAME = "deletes";
    protected Connection connection;
    public QueryPerfStats querystats;
    private long lastQueryPlanTime;
    private static HydraThreadLocal localconnection;
    private static HydraThreadLocal localquerystats;
    private static HydraThreadLocal locallastqueryplantime;

    public static void tmpTask() throws SQLException {
        FabricServerDescription fsd = GfxdTestConfig.getInstance().getFabricServerDescription("tester");
    }

    public static void createLocatorTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initLocalParameters();
        c.createLocator();
    }

    private void createLocator() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                DistributedSystemHelper.createLocator();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.noop();
                break;
            }
            case 1: {
                FabricServerHelper.createLocator();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void startLocatorTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initLocalParameters();
        c.startLocator();
    }

    private void startLocator() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                DistributedSystemHelper.startLocatorAndAdminDS();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                LonerHelper.connect();
                break;
            }
            case 1: {
                String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
                if (networkServerConfig == null) {
                    QueryPerfClient.log().info("Starting peer locator only");
                    FabricServerHelper.startLocator();
                    break;
                }
                QueryPerfClient.log().info("Starting network locator");
                FabricServerHelper.startLocator(networkServerConfig);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void startFabricServerTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.startFabricServer();
        c.updateHydraThreadLocals();
    }

    protected void startFabricServer() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                DistributedSystemHelper.connect();
                Cache c = CacheHelper.createCache((String)ConfigPrms.getCacheConfig());
                this.tm = this.getTxMgr(c);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                LonerHelper.connect();
                break;
            }
            case 1: {
                this.startFabricServer(QueryPerfPrms.retryOnXBM09());
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void startFabricServer(boolean retryOnXBM09) {
        boolean started = false;
        while (!started) {
            try {
                FabricServerHelper.startFabricServer();
                started = true;
            }
            catch (HydraRuntimeException e) {
                if (retryOnXBM09 && e.getCause() != null && e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getSQLState().equalsIgnoreCase("XBM09")) {
                    QueryPerfClient.log().info("Retrying in 20 seconds due to XBM09: " + e.getCause().getMessage());
                    MasterController.sleepForMs((int)20000);
                    continue;
                }
                throw e;
            }
        }
    }

    public static void startNetworkServerTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.startNetworkServer();
        c.updateHydraThreadLocals();
    }

    private void startNetworkServer() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                BridgeHelper.startBridgeServer((String)ConfigPrms.getBridgeConfig());
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.noop();
                break;
            }
            case 1: {
                String networkServerConfig = GfxdConfigPrms.getNetworkServerConfig();
                NetworkServerHelper.startNetworkServers(networkServerConfig);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void killServerTask() throws ClientVmNotFoundException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.ttgid == 0) {
            String target = QueryPerfPrms.getKillTarget();
            Log.getLogWriter().info("Killing a " + target);
            ClientVmInfo info = new ClientVmInfo(null, target, null);
            Log.getLogWriter().info("Killing this server: " + info);
            ClientVmMgr.stop((String)("Stopping " + info), (int)-21, (int)-32, (ClientVmInfo)info);
            Log.getLogWriter().info("Killed this server: " + info);
        }
    }

    public static void shutDownAllTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.ttgid == 0) {
            int sleepSec = QueryPerfPrms.getSleepBeforeShutdownSec();
            if (sleepSec > 0) {
                Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds before shutdown");
                MasterController.sleepForMs((int)(sleepSec * 1000));
                Log.getLogWriter().info("Done sleeping before shutdown");
            }
            FabricServerHelper.shutDownAllFabricServers(300);
        }
    }

    public static synchronized void waitForServerShutdownTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.jid == 0) {
            c.waitForServerShutdown();
        }
    }

    protected void waitForServerShutdown() {
        while (!FabricServerHelper.isFabricServerStopped()) {
            MasterController.sleepForMs((int)5000);
        }
    }

    public static void bounceSelfTask() throws ClientVmNotFoundException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.jid == 0) {
            c.bounceSelf();
        }
    }

    private void bounceSelf() throws ClientVmNotFoundException {
        Log.getLogWriter().info("Bouncing self, catch you later...");
        ClientVmMgr.stopAsync((String)"Killing myself nicely with immediate restart", (int)-20, (int)-30);
    }

    public static void connectLonerTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.connectLoner();
        c.updateHydraThreadLocals();
    }

    private void connectLoner() throws SQLException {
        switch (this.queryAPI) {
            case 1: {
                LonerHelper.connect();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void connectPeerClientTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.connectPeerClient();
        c.updateHydraThreadLocals();
    }

    private void connectPeerClient() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                Cache c = CacheHelper.createCache((String)ConfigPrms.getCacheConfig());
                this.tm = this.getTxMgr(c);
                break;
            }
            case 3: 
            case 4: {
                LonerHelper.connect();
                this.connection = QueryUtil.mySQLSetup(this);
                break;
            }
            case 5: {
                LonerHelper.connect();
                this.connection = QueryUtil.oracleSetup(this);
                break;
            }
            case 7: {
                LonerHelper.connect();
                this.connection = QueryUtil.gpdbSetup(this);
                break;
            }
            case 6: {
                LonerHelper.connect();
                this.connection = QueryUtil.rteSetup(this);
                break;
            }
            case 1: {
                this.connection = QueryUtil.gfxdEmbeddedSetup(this);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void connectThinClientTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.connectThinClient();
        c.updateHydraThreadLocals();
    }

    private void connectThinClient() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                Cache c = CacheHelper.createCache((String)ConfigPrms.getCacheConfig());
                this.tm = this.getTxMgr(c);
                break;
            }
            case 3: 
            case 4: {
                LonerHelper.connect();
                this.connection = QueryUtil.mySQLSetup(this);
                break;
            }
            case 5: {
                LonerHelper.connect();
                this.connection = QueryUtil.oracleSetup(this);
                break;
            }
            case 7: {
                LonerHelper.connect();
                this.connection = QueryUtil.gpdbSetup(this);
                break;
            }
            case 6: {
                LonerHelper.connect();
                this.connection = QueryUtil.rteSetup(this);
                break;
            }
            case 1: {
                LonerHelper.connect();
                this.connection = QueryUtil.gfxdClientSetup(this);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void connectThinWanClientTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.connectThinWanClient();
        c.updateHydraThreadLocals();
    }

    private void connectThinWanClient() throws SQLException {
        switch (this.queryAPI) {
            case 1: {
                LonerHelper.connect();
                this.connection = QueryUtil.gfxdWanClientSetup(this);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void closeConnectionTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.closeConnection();
        c.updateHydraThreadLocals();
    }

    private void closeConnection() throws SQLException {
        if (this.connection != null) {
            try {
                Log.getLogWriter().info("Closing connection (after first committing) " + this.connection);
                try {
                    this.connection.commit();
                }
                catch (SQLException e) {
                    if (QueryPerfPrms.isHA() && e.getMessage().contains("Please retry the operation")) {
                        Log.getLogWriter().info("Connection already closed due to server failure");
                        this.connection = null;
                    }
                    throw e;
                }
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
                Log.getLogWriter().info("Closed connection");
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase("X0Z01") && QueryPerfPrms.isHA()) {
                    Log.getLogWriter().info("Connection already closed due to server failure");
                    this.connection = null;
                }
                throw e;
            }
        } else {
            Log.getLogWriter().info("Connection already closed");
        }
    }

    protected Connection openTmpConnection() throws SQLException {
        Connection conn;
        if (this.connection == null) {
            conn = QueryUtil.gfxdEmbeddedSetup(this);
            conn.setTransactionIsolation(0);
        } else {
            conn = this.connection;
        }
        return conn;
    }

    protected void closeTmpConnection(Connection conn) throws SQLException {
        if (this.connection == null) {
            conn.close();
        }
    }

    public static void createBucketsTask() throws InterruptedException, SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.sttgid == 0) {
            if (c.queryAPI == 2) {
                c.assignBuckets();
            } else if (c.queryAPI == 1) {
                c.assignBucketsForTables();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignBucketsForTables() throws SQLException {
        Connection conn = this.openTmpConnection();
        try {
            CallableStatement cs = conn.prepareCall("call SYS.CREATE_ALL_BUCKETS( ? )");
            List<String> tableNames = this.getPartitionedTables();
            for (String tableName : tableNames) {
                Log.getLogWriter().info("Creating buckets for table " + tableName);
                cs.setString(1, tableName);
                cs.execute();
                Log.getLogWriter().info("Created buckets for table " + tableName);
            }
            cs.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void rebalanceBucketsTask() throws InterruptedException, SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.sttgid == 0) {
            Log.getLogWriter().info("Rebalancing buckets");
            if (c.queryAPI == 2) {
                c.rebalance();
            } else if (c.queryAPI == 1) {
                c.rebalanceTables();
            }
            Log.getLogWriter().info("Rebalanced buckets");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebalanceTables() throws InterruptedException, SQLException {
        Connection conn = this.openTmpConnection();
        try {
            CallableStatement cs = conn.prepareCall("call SYS.REBALANCE_ALL_BUCKETS()");
            cs.execute();
            cs.close();
            ResourceManager rm = CacheFactory.getAnyInstance().getResourceManager();
            Log.getLogWriter().info("Waiting for existing rebalance");
            for (RebalanceOperation op : rm.getRebalanceOperations()) {
                op.getResults();
            }
            Log.getLogWriter().info("Waited for existing rebalance");
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void checkBucketsTask() throws SQLException {
        List<String> tableNames;
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.queryAPI == 1 && c.jid == 0 && (tableNames = c.getPartitionedThings()) != null) {
            for (String tableName : tableNames) {
                c.checkBuckets(tableName);
            }
        }
    }

    private void checkBuckets(String tableName) {
        String err = "";
        String warning = "";
        Statistics prstats = this.getPRStatsByTextId(tableName);
        if (prstats != null) {
            int primariesPerDatahost;
            int datahosts = this.getNumDatahosts(tableName);
            if (datahosts < 2) {
                return;
            }
            Log.getLogWriter().info("Checking bucket balance for " + tableName + " with " + datahosts + " datahosts");
            int copies = prstats.getInt("configuredRedundantCopies") + 1;
            int primaries = prstats.getInt("primaryBucketCount");
            int buckets = prstats.getInt("bucketCount");
            int totalPrimaries = prstats.getInt("totalNumBuckets");
            int totalBuckets = totalPrimaries * copies;
            int bucketsPerDatahost = totalBuckets / datahosts;
            if (buckets != bucketsPerDatahost && (totalBuckets % datahosts == 0 || buckets != bucketsPerDatahost + 1)) {
                err = err + tableName + " has " + buckets + " buckets.\n";
                List<Integer> bucketList = this.getBucketList(tableName);
                Log.getLogWriter().info("Bucket list for " + tableName + " is " + bucketList);
            }
            if (primaries != (primariesPerDatahost = totalPrimaries / datahosts) && (totalPrimaries % datahosts == 0 || primaries != primariesPerDatahost + 1)) {
                err = err + tableName + " has " + primaries + " primary buckets.\n";
                List<Integer> bucketList = this.getPrimaryBucketList(tableName);
                Log.getLogWriter().info("Primary bucket list for " + tableName + " is " + bucketList);
            }
            Log.getLogWriter().info("Checked bucket balance for " + tableName + ", found " + buckets + " buckets and " + primaries + " primaries");
            if (warning.length() > 0) {
                Log.getLogWriter().warning("Bucket validation issues:\n" + warning);
            }
            if (err.length() > 0) {
                String s = "Bucket validation failures:\n" + err;
                throw new QueryPerfException(s);
            }
        }
    }

    public static void printBucketListTask() throws SQLException {
        List<String> tableNames;
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.queryAPI == 1 && c.jid == 0 && (tableNames = c.getPartitionedThings()) != null) {
            for (String tableName : tableNames) {
                List<Integer> bucketList = c.getBucketList(tableName);
                Log.getLogWriter().info("Bucket list for " + tableName + " is " + bucketList);
            }
        }
    }

    protected List<Integer> getBucketList(String tableName) {
        Cache cache = CacheHelper.getCache();
        for (PartitionRegionInfo pri : PartitionRegionHelper.getPartitionRegionInfo((Cache)cache)) {
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(tableName)) continue;
            Log.getLogWriter().info("Region path is " + regionPath);
            PartitionedRegion pr = (PartitionedRegion)cache.getRegion(regionPath);
            Log.getLogWriter().info("Region name is " + pr.getName());
            PartitionedRegionDataStore dataStore = pr.getDataStore();
            List bids = pr.getLocalBucketsListTestOnly();
            for (Integer bid : bids) {
                Log.getLogWriter().info(pr.getName() + ": size of bucket[" + bid + "]=" + dataStore.getBucketSize(bid.intValue()));
            }
            return bids;
        }
        return null;
    }

    public static void setPrimaryBucketListTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        if (c.jid == 0 && (c.queryAPI == 1 || c.queryAPI == 2)) {
            List<String> tableNames = c.getPartitionedThings();
            if (tableNames != null) {
                for (String tableName : tableNames) {
                    if (PrimaryBucketList == null) {
                        PrimaryBucketList = new HashMap<String, List<Integer>>();
                    }
                    PrimaryBucketList.put(tableName, c.getPrimaryBucketList(tableName));
                }
            }
            Log.getLogWriter().info("Primary buckets: " + PrimaryBucketList);
        }
    }

    protected List<Integer> getPrimaryBucketList(String tableName) {
        for (PartitionRegionInfo pri : PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache())) {
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(tableName)) continue;
            Log.getLogWriter().info("Region path is " + regionPath);
            Region region = CacheHelper.getCache().getRegion(regionPath);
            String regionName = region.getName();
            Log.getLogWriter().info("Region name is " + regionName);
            return ((PartitionedRegion)region).getLocalPrimaryBucketsListTestOnly();
        }
        return null;
    }

    public static void checkDataLoadTask() throws SQLException {
        if (QueryPerfPrms.checkDataLoadEnabled()) {
            List<String> tableNames;
            QueryPerfClient c = new QueryPerfClient();
            c.initialize();
            if (c.queryAPI == 1 && c.jid == 0 && (tableNames = c.getPartitionedThings()) != null) {
                for (String tableName : tableNames) {
                    List<Integer> bucketList = c.getBucketList(tableName);
                    Log.getLogWriter().info("Bucket list for " + tableName + " is " + bucketList);
                }
                for (String tableName : tableNames) {
                    c.checkDataLoad(tableName);
                }
            }
        }
    }

    private void checkDataLoad(String tableName) {
        String err = "";
        String warning = "";
        for (PartitionRegionInfo pri : PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache())) {
            int datahosts;
            String regionPath = pri.getRegionPath();
            if (!regionPath.contains(tableName) || regionPath.contains("AsyncEventQueue_GEMFIRE_HDFS_BUCKETSORTED_QUEUE") || (datahosts = this.getNumDatahosts(tableName)) < 2) continue;
            Log.getLogWriter().info("Checking entry load for " + tableName + " with " + datahosts + " datahosts");
            ArrayList<Long> sizes = new ArrayList<Long>();
            Set pmis = pri.getPartitionMemberInfo();
            long maxSize = 0L;
            for (PartitionMemberInfo pmi : pmis) {
                long size = pmi.getSize();
                if (size > maxSize) {
                    maxSize = size;
                }
                sizes.add(size);
            }
            if (maxSize >= 0L) {
                for (Long size : sizes) {
                    double d = size < maxSize ? (double)size.longValue() / (double)maxSize : (double)maxSize / (double)size.longValue();
                    double ratio = d;
                    if (!(ratio < 0.9)) continue;
                    err = err + tableName + " is imbalanced: " + sizes + "\n";
                    break;
                }
            }
            Log.getLogWriter().info("Checked entry load for " + tableName + ", found entry sizes " + sizes + " bytes");
        }
        if (warning.length() > 0) {
            Log.getLogWriter().warning("Data load balance issues:\n" + warning);
        }
        if (err.length() > 0) {
            throw new QueryPerfException("Data load balance failures:\n" + err);
        }
    }

    private int getNumDatahosts(String tableName) {
        for (PartitionRegionInfo pri : PartitionRegionHelper.getPartitionRegionInfo((Cache)CacheHelper.getCache())) {
            if (!pri.getRegionPath().contains(tableName)) continue;
            Set pmis = pri.getPartitionMemberInfo();
            return pmis.size();
        }
        return 0;
    }

    public Statistics getPRStatsByTextId(String tableName) {
        String textId = this.getTextId(tableName);
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        Statistics[] stats = ds.findStatisticsByTextId(textId);
        Statistics prStats = null;
        for (int i = 0; i < stats.length; ++i) {
            if (!stats[i].getType().getName().equals("PartitionedRegionStats")) continue;
            prStats = stats[i];
        }
        return prStats;
    }

    public List<String> getPartitionedThings() throws SQLException {
        List<String> tableNames = null;
        switch (this.queryAPI) {
            case 2: {
                tableNames = this.getPartitionedRegions();
                break;
            }
            case 1: {
                tableNames = this.getPartitionedTables();
                break;
            }
        }
        return tableNames;
    }

    public List<String> getPartitionedRegions() {
        ArrayList<String> regionNames = new ArrayList<String>();
        Cache c = CacheHelper.getCache();
        if (c != null) {
            for (Region r : c.rootRegions()) {
                if (!r.getAttributes().getDataPolicy().withPartitioning()) continue;
                regionNames.add(r.getName());
            }
        }
        return regionNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPartitionedTables() throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection conn = this.openTmpConnection();
        try {
            PreparedStatement ps = conn.prepareStatement("SELECT tablename, datapolicy FROM sys.systables WHERE tableschemaname='APP'");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String tablename = rs.getString("tablename");
                String datapolicy = rs.getString("datapolicy");
                if (!datapolicy.contains("PARTITION")) continue;
                tableNames.add(tablename);
            }
            rs.close();
            rs = null;
            ps.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
        return tableNames;
    }

    private String getTextId(String tableName) {
        switch (this.queryAPI) {
            case 2: {
                return "/" + tableName;
            }
            case 1: {
                return "/APP/" + tableName;
            }
        }
        throw new UnsupportedOperationException("Unsupported query API");
    }

    protected boolean isPrimary(Object key, String regionName) {
        Region region = CacheHelper.getCache().getRegion(regionName);
        DistributedMember thisDM = DistributedSystemHelper.getDistributedSystem().getDistributedMember();
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            DistributedMember thatDM = PartitionRegionHelper.getPrimaryMemberForKey((Region)region, (Object)key);
            return thisDM.equals(thatDM);
        }
        return false;
    }

    public static void setEvictionHeapPercentageTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.setEvictionHeapPercentage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEvictionHeapPercentage() throws SQLException {
        int percentage = QueryPerfPrms.getEvictionHeapPercentage();
        if (percentage > 0) {
            if (this.queryAPI == 1) {
                Connection conn = this.openTmpConnection();
                try {
                    CallableStatement cs = conn.prepareCall("call SYS.SET_EVICTION_HEAP_PERCENTAGE(?)");
                    cs.setInt(1, percentage);
                    cs.execute();
                    cs.close();
                }
                finally {
                    this.closeTmpConnection(conn);
                }
                float evictionHeapPercentage = Misc.getGemFireCache().getResourceManager().getEvictionHeapPercentage();
                Log.getLogWriter().info("Set evictionHeapPercentage=" + evictionHeapPercentage);
            } else {
                this.unsupported();
            }
        }
    }

    public static void createAndStartDBSynchronizerTask() throws SQLException {
        String dbsName = QueryPerfPrms.getDBSynchronizerName();
        if (dbsName != null) {
            QueryPerfClient c = new QueryPerfClient();
            c.initialize();
            if (c.ttgid == 0) {
                c.createAndStartDBSynchronizer(dbsName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndStartDBSynchronizer(String dbsName) throws SQLException {
        String driver = null;
        String url = null;
        switch (QueryPerfPrms.getDBAPI()) {
            case 3: 
            case 4: {
                driver = QueryUtil.mySQLDriver();
                url = QueryUtil.mySQLURL();
                break;
            }
            case 5: {
                driver = QueryUtil.oracleDriver();
                url = QueryUtil.oracleURL();
                break;
            }
            case 7: {
                driver = QueryUtil.gpdbDriver();
                url = QueryUtil.gpdbURL();
                break;
            }
            default: {
                this.unsupported();
            }
        }
        String query = "create asynceventlistener " + QueryPerfPrms.getDBSynchronizerName() + " ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer'" + " initparams '" + driver + "," + url + "' " + QueryPerfPrms.getDBSynchronizerConfig() + " )";
        String groups = QueryPerfPrms.getDBSynchronizerServerGroups();
        if (groups != null) {
            query = query + " server groups ( " + groups + " )";
        }
        Connection conn = this.openTmpConnection();
        Statement stmt = conn.createStatement();
        Log.getLogWriter().info("Creating dbsychronizer \"" + query + "\"");
        stmt.execute(query);
        Log.getLogWriter().info("Created dbsychronizer \"" + query + "\"");
        try {
            CallableStatement cs = conn.prepareCall("call SYS.START_ASYNC_EVENT_LISTENER( ? )");
            Log.getLogWriter().info("Starting dbsychronizer " + dbsName);
            cs.setString(1, dbsName);
            cs.execute();
            Log.getLogWriter().info("Started dbsychronizer " + dbsName);
            cs.close();
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void deleteQueryDataContainersTask() throws SQLException {
        if (useExistingData) {
            Log.getLogWriter().info("No tables dropped, using existing data");
            return;
        }
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.initAdditionalLocalParameters();
        if (c.sttgid == 0) {
            c.deleteQueryDataContainers();
        }
    }

    private void deleteQueryDataContainers() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                this.noop();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.dropTables();
                break;
            }
            case 1: {
                this.dropTables();
                this.dropSchema();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void dropSchema() {
        String stmt = ((SQLQueryFactory)this.queryFactory).getDropSchemaStatement();
        Log.getLogWriter().info("Dropping schema using: " + stmt);
        try {
            ((SQLQueryFactory)this.queryFactory).execute(stmt, this.connection);
            this.connection.commit();
        }
        catch (SQLException e) {
            Log.getLogWriter().warning("Failed to drop shema: " + e.getMessage());
        }
    }

    private void dropTables() {
        List stmts = ((SQLQueryFactory)this.queryFactory).getDropTableStatements();
        for (String stmt : stmts) {
            Log.getLogWriter().info("Dropping table using: " + stmt);
            try {
                ((SQLQueryFactory)this.queryFactory).execute(stmt, this.connection);
                this.connection.commit();
            }
            catch (SQLException e) {
                Log.getLogWriter().warning("Failed to drop table: " + e.getMessage());
            }
        }
    }

    protected void enableQueryPlanGeneration() throws SQLException {
        if (!this.queryPlanGenerationEnabled && this.generateQueryPlan()) {
            Statement stmt = this.connection.createStatement();
            stmt.execute("call SYSCS_UTIL.SET_EXPLAIN_CONNECTION(1)");
            stmt.execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
            stmt.close();
            Log.getLogWriter().info("Enabled query plan generation and timing");
            this.queryPlanGenerationEnabled = true;
            this.logQueriesSetting = this.getLogQueries();
            this.setLogQueries(true);
        }
    }

    protected void disableQueryPlanGeneration() throws SQLException {
        if (this.queryPlanGenerationEnabled) {
            Statement stmt = this.connection.createStatement();
            stmt.execute("call SYSCS_UTIL.SET_EXPLAIN_CONNECTION(0)");
            stmt.execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(0)");
            stmt.close();
            Log.getLogWriter().info("Disabled query plan generation and timing");
            this.queryPlanGenerationEnabled = false;
            this.setLogQueries(this.logQueriesSetting);
        }
    }

    protected boolean getLogQueries() {
        return ((BaseQueryFactory)this.queryFactory).getLogQueries();
    }

    protected void setLogQueries(boolean b) {
        ((BaseQueryFactory)this.queryFactory).setLogQueries(b);
    }

    protected boolean generateQueryPlan() {
        return this.queryPlanFrequency != 0L && this.queryAPI == 1 && this.sttgid < this.maxQueryPlanners && this.timeToGenerateQueryPlan();
    }

    protected boolean timeToGenerateQueryPlan() {
        long now = System.currentTimeMillis();
        if (now - this.lastQueryPlanTime > this.queryPlanFrequency) {
            this.lastQueryPlanTime = now;
            return true;
        }
        return false;
    }

    public static void dumpQueryPlansTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(-1);
        if (c.queryAPI == 1 && c.sttgid == 0) {
            c.dumpQueryPlans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpQueryPlans() throws SQLException {
        Connection conn = this.openTmpConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet r = stmt.executeQuery("select STMT_ID, STMT_TEXT from SYS.STATEMENTPLANS");
            Log.getLogWriter().info("Extracting query plans");
            int numQueryPlans = 0;
            while (r.next()) {
                ++numQueryPlans;
                String stmt_id = r.getString("STMT_ID");
                String stmtInfo = "stmt_id = " + stmt_id + " statement = " + r.getString("STMT_TEXT");
                ExecutionPlanUtils plan = new ExecutionPlanUtils(conn, stmt_id, null, true);
                String planAsText = String.valueOf(plan.getPlanAsText(null)).trim();
                Log.getLogWriter().info("Query plan...\n" + stmtInfo + "\n" + planAsText);
            }
            Log.getLogWriter().info("Extracted " + numQueryPlans + " query plans");
        }
        finally {
            this.closeTmpConnection(conn);
        }
    }

    public static void reportMemoryAnalyticsTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.reportMemoryAnalytics();
    }

    public static void measureEmptyTableMemoryUsageTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.measureEmptyTableMemoryUsage();
    }

    public static void measureLoadedTableMemoryUsageTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.measureLoadedTableMemoryUsage();
    }

    private void reportMemoryAnalytics() throws SQLException {
        if (this.queryAPI != 1) {
            this.noop();
        } else {
            Log.getLogWriter().info("Printing memory analytics...");
            Connection tmpconn = QueryUtil.gfxdEmbeddedSetup(this);
            tmpconn.setTransactionIsolation(0);
            String stmt = "select * from sys.memoryanalytics";
            List<String> sizerHints = QueryPerfPrms.getSizerHints();
            if (sizerHints != null) {
                stmt = stmt + " -- GEMFIREXD-PROPERTIES";
                String hints = "";
                for (String sizerHint : sizerHints) {
                    if (hints.length() > 0) {
                        hints = hints + ",";
                    }
                    hints = hints + " sizerHints=" + sizerHint;
                }
                stmt = stmt + hints;
            }
            Log.getLogWriter().info("Executing " + stmt);
            PreparedStatement memstmt = tmpconn.prepareStatement(stmt);
            ResultSet rs = memstmt.executeQuery();
            Log.getLogWriter().info("Executed " + stmt + ", reading results");
            long total = 0L;
            long ndxTotal = 0L;
            long ndxOverheadTotal = 0L;
            long tableTotal = 0L;
            long tableRowTotal = 0L;
            long ndxRowTotal = 0L;
            long footprintTotal = 0L;
            while (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                StringBuilder s = new StringBuilder();
                String sqlentity = null;
                String memory = null;
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String colname = rsmd.getColumnName(i);
                    Object obj = rs.getObject(colname);
                    s.append(colname).append("=").append(obj).append(" ");
                    if (colname.equals("SQLENTITY")) {
                        sqlentity = obj.toString();
                    }
                    if (!colname.equals("MEMORY")) continue;
                    memory = obj.toString();
                }
                Log.getLogWriter().info(s.toString());
                if (sqlentity != null && memory != null) {
                    int index = memory.indexOf(" ");
                    String mem = index == -1 ? memory : memory.substring(0, index);
                    long[] nums = this.getLongs(mem.split(","));
                    if (nums.length == 3) {
                        if (sqlentity.contains("(Entry Size, Value Size, Row Count)")) {
                            tableTotal += nums[0] + nums[1];
                            tableRowTotal += nums[2];
                        } else if (sqlentity.contains("(Index Entry Size, Value Size, Row Count)")) {
                            ndxTotal += nums[0] + nums[1];
                            ndxRowTotal += nums[2];
                        } else if (sqlentity.contains("(Index Entry Overhead, SkipList Size, Max Level)")) {
                            ndxOverheadTotal += nums[0] + nums[1] + nums[2];
                        } else if (sqlentity.contains("(gemfirexd,gemfire,others)")) {
                            footprintTotal += nums[0] + nums[1] + nums[2];
                        } else {
                            Log.getLogWriter().warning("Skipping memory: " + mem);
                        }
                    } else {
                        Log.getLogWriter().warning("Skipping memory: " + mem);
                    }
                }
                total = tableTotal + ndxTotal + ndxOverheadTotal;
            }
            Log.getLogWriter().info("MEMORY: table=" + tableTotal + " ndx=" + ndxTotal + " ndxOverhead=" + ndxOverheadTotal + " totalTableNdxOverheadMemory=" + total + " footprint=" + footprintTotal);
            Log.getLogWriter().info("ENTRIES: table=" + tableRowTotal + " ndx=" + ndxRowTotal);
            rs.close();
            rs = null;
            tmpconn.close();
            Log.getLogWriter().info("Done printing memory analytics");
        }
    }

    private long[] getLongs(String[] strs) {
        long[] nums = new long[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            try {
                nums[i] = Long.parseLong(strs[i]);
                continue;
            }
            catch (NumberFormatException e) {
                String s = strs[i] + " is not a long";
                throw new QueryPerfException(s);
            }
        }
        return nums;
    }

    private void measureEmptyTableMemoryUsage() {
        if (this.queryAPI != 1) {
            this.noop();
        } else if (QueryPerfPrms.enableMemoryStats()) {
            this.querystats.setEmptyTableMemUse(this.usedMemory());
        } else {
            String s = "This operation is a noop since " + BasePrms.nameForKey((Long)QueryPerfPrms.enableMemoryStats) + "=false";
            Log.getLogWriter().info(s);
        }
    }

    private void measureLoadedTableMemoryUsage() {
        if (this.queryAPI != 1) {
            this.noop();
        } else if (QueryPerfPrms.enableMemoryStats()) {
            this.querystats.setLoadedTableMemUse(this.usedMemory());
        } else {
            String s = "This operation is a noop since " + BasePrms.nameForKey((Long)QueryPerfPrms.enableMemoryStats) + "=false";
            Log.getLogWriter().info(s);
        }
    }

    protected long usedMemory() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long freeMem = runtime.freeMemory();
        long totalMem = runtime.totalMemory();
        long usedMem = totalMem - freeMem;
        return usedMem;
    }

    public static void createQueryDataContainersTask() throws SQLException {
        if (useExistingData) {
            Log.getLogWriter().info("No tables created, using existing data");
            return;
        }
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.initAdditionalLocalParameters();
        if (c.sttgid == 0) {
            c.deleteQueryDataContainers();
            c.createQueryDataContainers();
        }
    }

    private void createQueryDataContainers() throws SQLException {
        switch (this.queryAPI) {
            case 0: 
            case 2: 
            case 20: 
            case 21: {
                this.noop();
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.createTables();
                break;
            }
            case 1: {
                this.createSchema();
                this.createTables();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void createQueryDataRegionsTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize();
        c.initAdditionalLocalParameters();
        c.createQueryDataRegions();
    }

    private void createQueryDataRegions() throws SQLException {
        switch (this.queryAPI) {
            case 20: 
            case 21: {
                this.loadDvdSerializer();
            }
            case 2: {
                ((GFEQueryFactory)this.queryFactory).createRegions();
                break;
            }
            case 0: {
                ((OQLQueryFactory)this.queryFactory).createRegions();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.noop();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void loadDvdSerializer() {
        try {
            Class<?> misc = Class.forName("com.pivotal.gemfirexd.internal.iapi.types.DataType");
            Method initMethod = misc.getMethod("init", null);
            initMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            Log.getLogWriter().info((Throwable)e);
        }
    }

    private void createSchema() throws SQLException {
        String stmt = ((SQLQueryFactory)this.queryFactory).getCreateSchemaStatement();
        Log.getLogWriter().info("Creating schema using: " + stmt);
        ((SQLQueryFactory)this.queryFactory).execute(stmt, this.connection);
        this.connection.commit();
    }

    private void createTables() throws SQLException {
        List stmts = ((SQLQueryFactory)this.queryFactory).getTableStatements();
        for (String stmt : stmts) {
            Log.getLogWriter().info("Creating table using: " + stmt);
            ((SQLQueryFactory)this.queryFactory).execute(stmt, this.connection);
        }
        this.connection.commit();
    }

    public static void createIndexesTask() throws SQLException, NameResolutionException, RegionNotFoundException, IndexExistsException, IndexNameConflictException {
        if (useExistingData) {
            Log.getLogWriter().info("No indexes created, using existing data");
            return;
        }
        if (QueryPerfPrms.createIndexes()) {
            QueryPerfClient c = new QueryPerfClient();
            c.initialize();
            c.initAdditionalLocalParameters();
            if (c.sttgid == 0) {
                c.createIndexes();
            }
        }
    }

    private void createIndexes() throws SQLException, NameResolutionException, RegionNotFoundException, IndexExistsException, IndexNameConflictException {
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.noop();
                break;
            }
            case 0: {
                this.createOQLIndex();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.createSQLIndexes();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void createSQLIndexes() throws SQLException {
        List stmts = ((SQLQueryFactory)this.queryFactory).getIndexStatements();
        for (String stmt : stmts) {
            int result = ((SQLQueryFactory)this.queryFactory).executeUpdate(stmt, this.connection);
            this.connection.commit();
        }
    }

    private void createOQLIndex() throws NameResolutionException, RegionNotFoundException, IndexExistsException, IndexNameConflictException {
        ((OQLQueryFactory)this.queryFactory).createIndexes();
    }

    public static void preparedCreateQueryDataTask() throws SQLException {
        if (useExistingData) {
            Log.getLogWriter().info("No data created, using existing data");
            throw new StopSchedulingTaskOnClientOrder();
        }
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230817);
        c.initAdditionalLocalParameters();
        c.preparedCreateQueryData();
    }

    private void preparedCreateQueryData() throws SQLException {
        List pstmts = null;
        List stmts = null;
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                pstmts = ((GFEQueryFactory)this.queryFactory).getPreparedInsertObjects();
                break;
            }
            case 0: {
                pstmts = ((OQLQueryFactory)this.queryFactory).getPreparedInsertObjects();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                stmts = ((SQLQueryFactory)this.queryFactory).getPreparedInsertStatements();
                pstmts = this.convertStmtsToPStmts(stmts, this.connection);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.begin();
            this.preparedCreateQueryData(key, pstmts, stmts);
            this.commit();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void preparedCreateQueryData(int i, List pstmts, List stmts) throws SQLException {
        long start = this.querystats.startCreate();
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.preparedInsertGFEData(i, pstmts);
                break;
            }
            case 0: {
                this.preparedInsertOQLData(i, pstmts);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.preparedInsertSQLData(i, pstmts, stmts);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        this.querystats.endCreate(start, this.histogram);
    }

    private void preparedInsertSQLData(int i, List pstmts, List stmts) throws SQLException {
        ((SQLQueryFactory)this.queryFactory).fillAndExecutePreparedInsertStatements(pstmts, stmts, i);
    }

    private void preparedInsertOQLData(int i, List pobjs) {
        ((OQLQueryFactory)this.queryFactory).fillAndExecutePreparedInsertObjects(pobjs, i);
    }

    private void preparedInsertGFEData(int i, List pobjs) {
        ((GFEQueryFactory)this.queryFactory).fillAndExecutePreparedInsertObjects(pobjs, i);
    }

    public static void directGetDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230814);
        c.initAdditionalLocalParameters();
        c.directGetData();
    }

    private void directGetData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.getDataFromRegion();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.preparedQueryQueryData();
                break;
            }
            case 6: {
                this.preparedQueryQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void getDataFromGFXDRegion() {
        int queryType = this.queryFactory.getQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.getDataFromGFXDRegion(key, queryType);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void getDataFromGFXDRegion(int i, int queryType) {
        Object rs = null;
        Object key = null;
        Region region = null;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
            Method getGemFireKeyMethod = c.getMethod("getGemFireKey", Integer.TYPE);
            Object[] idArray = new Object[]{i};
            key = getGemFireKeyMethod.invoke(null, idArray);
            region = ((SQLQueryFactory)this.queryFactory).getRegionForQuery(queryType);
        }
        catch (Exception e) {
            Log.getLogWriter().info((Throwable)e);
        }
        long start = this.querystats.startQuery();
        ((SQLQueryFactory)this.queryFactory).directGet(key, region);
        this.querystats.endQuery(start, this.histogram);
    }

    private void getDataFromRegion() {
        int queryType = this.queryFactory.getQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.getDataFromRegion(key, queryType);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void getDataFromRegion(int i, int queryType) {
        Region region = null;
        Object entry = null;
        Object key = null;
        switch (this.queryAPI) {
            case 20: 
            case 21: {
                try {
                    Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.engine.Misc");
                    Method getGemFireKeyMethod = c.getMethod("getGemFireKey", Integer.TYPE);
                    Object[] idArray = new Object[]{i};
                    key = getGemFireKeyMethod.invoke(null, idArray);
                }
                catch (Exception e) {
                    Log.getLogWriter().info((Throwable)e);
                }
                region = ((GFEQueryFactory)this.queryFactory).getRegionForQuery(queryType);
                long start = this.querystats.startQuery();
                entry = ((GFEQueryFactory)this.queryFactory).directGet(key, region);
                ((GFEQueryFactory)this.queryFactory).readResultSet(queryType, entry);
                this.querystats.endQuery(start, this.histogram);
                break;
            }
            case 2: {
                region = ((GFEQueryFactory)this.queryFactory).getRegionForQuery(queryType);
                key = new Integer(i);
                long start = this.querystats.startQuery();
                entry = ((GFEQueryFactory)this.queryFactory).directGet(key, region);
                ((GFEQueryFactory)this.queryFactory).readResultSet(queryType, entry);
                this.querystats.endQuery(start, this.histogram);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    public static void preparedUpdateQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230815);
        c.initAdditionalLocalParameters();
        c.directPreparedUpdateData();
    }

    private void directPreparedUpdateData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.updateDataFromRegion();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.preparedUpdateQueryData();
                break;
            }
            case 6: {
                this.preparedUpdateQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void updateDataFromRegion() {
        int queryType = this.queryFactory.getUpdateQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.begin();
            this.updateDataFromRegion(key, queryType);
            this.commit();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void updateDataFromRegion(int i, int queryType) {
        Object region = null;
        Object entry = null;
        Object key = null;
        switch (this.queryAPI) {
            case 2: {
                long start = this.querystats.startUpdate();
                ((GFEQueryFactory)this.queryFactory).directUpdate(i, queryType);
                this.querystats.endUpdate(start, this.histogram);
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void preparedUpdateQueryData() throws SQLException {
        int queryType = this.queryFactory.getUpdateQueryType();
        String stmt = this.queryFactory.getPreparedQuery(queryType);
        PreparedStatement pstmt = this.connection.prepareStatement(stmt);
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.begin();
            this.preparedUpdateQueryData(key, queryType, pstmt, stmt);
            this.commit();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        pstmt.close();
    }

    private void preparedUpdateQueryData(int i, int queryType, PreparedStatement pstmt, String stmt) throws SQLException {
        long start = this.querystats.startUpdate();
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.noop();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ((SQLQueryFactory)this.queryFactory).fillAndExecuteUpdatePreparedQueryStatement(pstmt, stmt, queryType, i);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        this.querystats.endUpdate(start, this.histogram);
    }

    public static void updateQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230815);
        c.initAdditionalLocalParameters();
        c.directUpdateData();
    }

    private void directUpdateData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.updateDataFromRegion();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                this.updateQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void updateQueryData() throws SQLException {
        int queryType = this.queryFactory.getUpdateQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.begin();
            this.updateQueryData(key, queryType);
            this.commit();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void updateQueryData(int i, int queryType) throws SQLException {
        String stmt = this.queryFactory.getQuery(queryType, i);
        long start = this.querystats.startUpdate();
        ((SQLQueryFactory)this.queryFactory).executeUpdate(stmt, this.connection);
        this.querystats.endUpdate(start, this.histogram);
    }

    public static void deleteQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230818);
        c.initAdditionalLocalParameters();
        c.deleteData();
    }

    private void deleteData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 1: {
                this.deleteQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void deleteQueryData() throws SQLException {
        int queryType = this.queryFactory.getDeleteQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.begin();
            this.deleteQueryData(key, queryType);
            this.commit();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void deleteQueryData(int i, int queryType) throws SQLException {
        String stmt = this.queryFactory.getQuery(queryType, i);
        long start = this.querystats.startUpdate();
        ((SQLQueryFactory)this.queryFactory).executeUpdate(stmt, this.connection);
        this.querystats.endUpdate(start, this.histogram);
    }

    public static void preparedDeleteQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230818);
        c.initAdditionalLocalParameters();
        c.preparedDeleteData();
    }

    private void preparedDeleteData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.preparedDeleteQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void preparedDeleteQueryData() throws SQLException {
        int queryType = this.queryFactory.getDeleteQueryType();
        String stmt = this.queryFactory.getPreparedQuery(queryType);
        PreparedStatement pstmt = this.connection.prepareStatement(stmt);
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.begin();
            this.preparedDeleteQueryData(key, queryType, pstmt, stmt);
            this.commit();
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        pstmt.close();
    }

    private void preparedDeleteQueryData(int i, int queryType, PreparedStatement pstmt, String stmt) throws SQLException {
        long start = this.querystats.startUpdate();
        switch (this.queryAPI) {
            case 2: 
            case 20: 
            case 21: {
                this.noop();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ((SQLQueryFactory)this.queryFactory).fillAndExecuteUpdatePreparedQueryStatement(pstmt, stmt, queryType, i);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        this.querystats.endUpdate(start, this.histogram);
    }

    public static void queryQueryDataTask() throws SQLException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230814);
        c.initAdditionalLocalParameters();
        c.queryQueryData();
    }

    private void queryQueryData() throws SQLException {
        int queryType = this.queryFactory.getQueryType();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.queryQueryData(key, queryType);
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void queryQueryData(int i, int queryType) throws SQLException {
        String stmt = this.queryFactory.getQuery(queryType, i);
        ResultSet rs = null;
        int rss = 0;
        long start = this.querystats.startQuery();
        switch (this.queryAPI) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                rs = ((SQLQueryFactory)this.queryFactory).execute(stmt, this.connection);
                rss = ((SQLQueryFactory)this.queryFactory).readResultSet(queryType, rs);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        Statement s = rs.getStatement();
        rs.close();
        s.close();
        this.querystats.endQuery(start, rss, this.histogram);
    }

    public static void preparedQueryQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230814);
        c.initAdditionalLocalParameters();
        c.preparedQueryQueryData();
    }

    private void preparedQueryQueryData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 0: {
                this.preparedOQLQueryQueryData();
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.preparedSQLQueryQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void preparedOQLQueryQueryData() throws NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        int queryType = this.queryFactory.getQueryType();
        String stmt = this.queryFactory.getPreparedQuery(queryType);
        Query query = PoolHelper.getPool((String)"clientPool").getQueryService().newQuery(stmt);
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.preparedOQLQueryQueryData(key, queryType, query);
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    private void preparedOQLQueryQueryData(int i, int queryType, Query query) throws NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        Object rs = null;
        long start = this.querystats.startQuery();
        switch (this.queryAPI) {
            case 0: {
                rs = ((OQLQueryFactory)this.queryFactory).fillAndExecutePreparedQueryStatement(query, queryType, i);
                ((OQLQueryFactory)this.queryFactory).readResultSet(queryType, rs);
                break;
            }
            default: {
                String s = "Unsupported API: " + QueryPrms.getAPIString((int)this.queryAPI);
                throw new HydraConfigException(s);
            }
        }
        this.querystats.endQuery(start, this.histogram);
    }

    private void preparedSQLQueryQueryData() throws SQLException {
        int queryType = this.queryFactory.getQueryType();
        String stmt = this.queryFactory.getPreparedQuery(queryType);
        PreparedStatement pstmt = this.connection.prepareStatement(stmt);
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.preparedSQLQueryQueryData(key, queryType, pstmt, stmt);
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        pstmt.close();
    }

    private void preparedSQLQueryQueryData(int i, int queryType, PreparedStatement pstmt, String stmt) throws SQLException {
        ResultSet rs = null;
        int rss = 0;
        long start = this.querystats.startQuery();
        switch (this.queryAPI) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                rs = ((SQLQueryFactory)this.queryFactory).fillAndExecutePreparedQueryStatement(pstmt, stmt, queryType, i);
                rss = ((SQLQueryFactory)this.queryFactory).readResultSet(queryType, rs);
                break;
            }
            default: {
                this.unsupported();
            }
        }
        this.querystats.endQuery(start, rss, this.histogram);
        rs.close();
    }

    public static void preparedMixQueryQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230814);
        c.initAdditionalLocalParameters();
        c.preparedMixQueryQueryData();
    }

    private void preparedMixQueryQueryData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.preparedSQLMixQueryQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void preparedSQLMixQueryQueryData() throws SQLException {
        HashMap<Integer, PreparedStatement> pstmts = new HashMap<Integer, PreparedStatement>();
        do {
            int queryType = this.queryFactory.getQueryType();
            PreparedStatement pstmt = (PreparedStatement)pstmts.get(queryType);
            String stmt = null;
            if (pstmt == null) {
                stmt = this.queryFactory.getPreparedQuery(queryType);
                pstmt = this.connection.prepareStatement(stmt);
                pstmts.put(queryType, pstmt);
            }
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            this.preparedSQLQueryQueryData(key, queryType, pstmt, stmt);
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
        for (PreparedStatement pstmt : pstmts.values()) {
            pstmt.close();
        }
    }

    public static void preparedMixUpdateAndQueryQueryDataTask() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        QueryPerfClient c = new QueryPerfClient();
        c.initialize(6230814);
        c.initAdditionalLocalParameters();
        c.preparedMixUpdateAndQueryQueryData();
    }

    private void preparedMixUpdateAndQueryQueryData() throws SQLException, NameResolutionException, TypeMismatchException, FunctionDomainException, QueryInvocationTargetException {
        switch (this.queryAPI) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.preparedSQLMixUpdateAndQueryQueryData();
                break;
            }
            default: {
                this.unsupported();
            }
        }
    }

    private void preparedSQLMixUpdateAndQueryQueryData() throws SQLException {
        int queryType = this.queryFactory.getQueryType();
        String stmtQuery = this.queryFactory.getPreparedQuery(queryType);
        PreparedStatement pstmtQuery = this.connection.prepareStatement(stmtQuery);
        int updateType = this.queryFactory.getUpdateQueryType();
        String stmtUpdate = this.queryFactory.getPreparedQuery(updateType);
        PreparedStatement pstmtUpdate = this.connection.prepareStatement(stmtUpdate);
        int updatePercentage = QueryPerfPrms.getUpdatePercentage();
        do {
            int key = this.getNextKey();
            this.executeTaskTerminator();
            this.executeWarmupTerminator();
            this.enableQueryPlanGeneration();
            int n = this.rng.nextInt(1, 100);
            if (n <= updatePercentage) {
                this.begin();
                this.preparedUpdateQueryData(key, updateType, pstmtUpdate, stmtUpdate);
                this.commit();
            } else {
                this.preparedSQLQueryQueryData(key, queryType, pstmtQuery, stmtQuery);
            }
            this.disableQueryPlanGeneration();
            ++this.batchCount;
            ++this.count;
            ++this.keyCount;
        } while (!this.executeBatchTerminator());
    }

    public static void openStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.openStatistics();
        c.updateHydraThreadLocals();
    }

    private void openStatistics() {
        if (this.querystats == null) {
            this.querystats = QueryPerfStats.getInstance();
            RemoteTestModule.openClockSkewStatistics();
        }
    }

    public static void closeStatisticsTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initHydraThreadLocals();
        c.closeStatistics();
        c.updateHydraThreadLocals();
    }

    protected void closeStatistics() {
        MasterController.sleepForMs((int)2000);
        if (this.querystats != null) {
            RemoteTestModule.closeClockSkewStatistics();
            this.querystats.close();
        }
    }

    public static void configureDebuggingTask() {
        QueryPerfClient c = new QueryPerfClient();
        c.initLocalVariables(-1);
        if (c.jid == 0) {
            Map<String, String> props;
            List<String> flags = QueryPerfPrms.getTraceFlags();
            if (flags != null) {
                Log.getLogWriter().info("Setting trace flags: " + flags);
                for (String flag : flags) {
                    SanityManager.DEBUG_SET((String)flag);
                    Log.getLogWriter().info("Set trace flag: " + flag);
                }
            }
            if ((props = QueryPerfPrms.getSystemProperties()) != null) {
                Log.getLogWriter().info("Setting system properties: " + props);
                for (String prop : props.keySet()) {
                    System.setProperty(prop, props.get(prop));
                    Log.getLogWriter().info("Set system property: " + prop + " " + props.get(prop));
                }
            }
        }
    }

    private void noop() {
        String s = "This operation is a noop for query API: " + QueryPrms.getAPIString((int)this.queryAPI);
        Log.getLogWriter().info(s);
    }

    protected void unsupported() {
        String s = "This operation is not supported for query API: " + QueryPrms.getAPIString((int)this.queryAPI);
        throw new HydraConfigException(s);
    }

    private List convertStmtsToPStmts(List stmts, Connection connection) throws SQLException {
        ArrayList<Object> pstmts = new ArrayList<Object>();
        for (int i = 0; i < stmts.size(); ++i) {
            if (stmts.get(i) instanceof String) {
                String stmt = (String)stmts.get(i);
                PreparedStatement pstmt = connection.prepareStatement(stmt);
                pstmts.add(pstmt);
                continue;
            }
            if (stmts.get(i) instanceof List) {
                pstmts.add(this.convertStmtsToPStmts((List)stmts.get(i), connection));
                continue;
            }
            String s = "Elements must be a statement or a list of statements.  The supplied element is of type " + stmts.get(i).getClass();
            throw new HydraConfigException(s);
        }
        return pstmts;
    }

    protected void initHydraThreadLocals() {
        super.initHydraThreadLocals();
        this.connection = this.getConnection();
        this.querystats = this.getQueryStats();
        this.lastQueryPlanTime = this.getLastQueryPlanTime();
    }

    protected void updateHydraThreadLocals() {
        super.updateHydraThreadLocals();
        this.setConnection(this.connection);
        this.setQueryStats(this.querystats);
        this.setLastQueryPlanTime(this.lastQueryPlanTime);
    }

    protected void resetHydraThreadLocals(boolean resetKeys) {
        super.resetHydraThreadLocals(resetKeys);
        locallastqueryplantime.set(null);
    }

    protected QueryPerfStats getQueryStats() {
        QueryPerfStats querystats = (QueryPerfStats)((Object)localquerystats.get());
        return querystats;
    }

    protected void setQueryStats(QueryPerfStats querystats) {
        localquerystats.set((Object)querystats);
    }

    protected Connection getConnection() {
        Connection connection = (Connection)localconnection.get();
        return connection;
    }

    protected void setConnection(Connection connection) {
        localconnection.set((Object)connection);
    }

    protected long getLastQueryPlanTime() {
        Long t = (Long)locallastqueryplantime.get();
        return t == null ? this.getStartTime() : t.longValue();
    }

    protected void setLastQueryPlanTime(long t) {
        locallastqueryplantime.set((Object)t);
    }

    protected void initLocalParameters() {
        super.initLocalParameters();
        this.queryAPI = QueryPrms.getAPI();
        this.txIsolation = QueryPerfPrms.getTxIsolation();
        this.queryPlanFrequency = QueryPerfPrms.getQueryPlanFrequency() * 1000L;
        this.maxQueryPlanners = QueryPerfPrms.getMaxQueryPlanners();
        this.iterationsSinceTxEnd = 1;
    }

    protected void initAdditionalLocalParameters() {
        this.queryObjectType = QueryPrms.getObjectType();
        this.queryFactory = QueryHelper.getQueryFactory(this.queryAPI, this.queryObjectType);
    }

    protected String nameFor(int name) {
        switch (name) {
            case 6230814: {
                return QUERY_NAME;
            }
            case 6230817: {
                return CREATE_NAME;
            }
            case 6230815: {
                return UPDATES_NAME;
            }
            case 6230818: {
                return DELETES_NAME;
            }
        }
        return super.nameFor(name);
    }

    protected boolean timeToExecuteBatchTerminator() {
        Object o;
        return this.batchTerminator != null && (Boolean)(o = this.executeTerminator(this.batchTerminator)) != false;
    }

    protected void terminateBatch() {
        this.cacheEndTrim(this.trimIntervals, this.trimInterval);
        this.updateHydraThreadLocals();
        DistributedSystem.releaseThreadsSockets();
    }

    protected void terminateWarmup() {
        this.warmedUp = true;
        this.warmupCount = this.count;
        this.warmupTime = System.currentTimeMillis() - this.startTime;
        this.sync();
        this.cacheStartTrim(this.trimIntervals, this.trimInterval);
    }

    protected void terminateTask() {
        if (this.warmupTerminator != null && !this.warmedUp) {
            String s = "Task terminator " + this.taskTerminator + " ran before warmup terminator " + this.warmupTerminator;
            throw new HydraConfigException(s);
        }
        this.cacheEndTrim(this.trimIntervals, this.trimInterval);
        this.updateHydraThreadLocals();
        throw new StopSchedulingTaskOnClientOrder();
    }

    protected CacheTransactionManager getTxMgr(Cache c) {
        return this.txIsolation != 0 ? c.getCacheTransactionManager() : null;
    }

    protected void begin() {
        if (this.tm != null) {
            this.tm.begin();
        }
    }

    protected void commit() {
        if (this.txIsolation != 0) {
            long start = this.querystats.startCommit();
            if (this.connection != null) {
                try {
                    this.connection.commit();
                }
                catch (SQLException e) {
                    throw new QueryPerfException("Commit failed: " + e);
                }
            } else if (this.tm != null) {
                try {
                    this.tm.commit();
                }
                catch (TransactionException e) {
                    throw new QueryPerfException("Commit failed: " + (Object)((Object)e));
                }
            } else {
                String s = "Don't know how to commit using query api: " + QueryPrms.getAPIString((int)this.queryAPI);
                throw new QueryPerfException(s);
            }
            this.querystats.endCommit(start);
        }
    }

    static {
        localconnection = new HydraThreadLocal();
        localquerystats = new HydraThreadLocal();
        locallastqueryplantime = new HydraThreadLocal();
    }
}

