/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd;

import cacheperf.comparisons.gemfirexd.QueryPerfException;
import hydra.BasePrms;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import objects.query.QueryPrms;

public class QueryPerfPrms
extends BasePrms {
    public static final String DEFAULT_DATABASE_NAME = "perfTest";
    public static final String DEFAULT_DATABASE_SERVER_HOST = "localhost";
    public static final int DEFAULT_DATABASE_SERVER_PORT = 3306;
    public static final String DEFAULT_USER = "root";
    public static final String DEFAULT_PASSWORD = "gemstone-test";
    public static final int TRANSACTION_NONE = 0;
    public static Long enableStats;
    public static Long enableTimeStats;
    public static Long enableMemoryStats;
    public static Long queryPlanFrequency;
    public static Long maxQueryPlanners;
    public static Long createIndexes;
    public static Long databaseName;
    public static Long databaseServerHost;
    public static Long databaseServerPort;
    public static Long user;
    public static Long password;
    public static Long evictionHeapPercentage;
    public static Long dbSynchronizerName;
    public static Long dbSynchronizerConfig;
    public static Long dbSynchronizerServerGroups;
    public static Long dbapi;
    public static Long updatePercentage;
    public static Long txIsolation;
    public static Long checkDataLoadEnabled;
    public static Long sizerHints;
    public static Long systemProperties;
    public static Long traceFlags;
    public static Long useExistingData;
    public static Long useNetworkLocator;
    public static Long killTarget;
    public static Long isHA;
    public static Long retryOnXBM09;
    public static Long sleepBeforeShutdownSec;

    public static boolean enableStats() {
        Long key = enableStats;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, false));
    }

    public static boolean enableTimeStats() {
        Long key = enableTimeStats;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, false));
    }

    public static boolean enableMemoryStats() {
        List<String> inputArgs;
        Long key = enableMemoryStats;
        boolean val = QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, false));
        if (val && (inputArgs = ManagementFactory.getRuntimeMXBean().getInputArguments()).contains("-XX:+DisableExplicitGC")) {
            String s = BasePrms.nameForKey((Long)enableMemoryStats) + "=" + val + " is incompatible with -XX:+DisableExplicitGC." + " Add \"hydra.VmPrms-extraVMArgs += -XX:-DisableExplicitGC\"" + " to the local.conf file and try again.";
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static long getQueryPlanFrequency() {
        Long key = queryPlanFrequency;
        return QueryPerfPrms.tasktab().longAt(key, QueryPerfPrms.tab().longAt(key, 0L));
    }

    public static int getMaxQueryPlanners() {
        Long key = maxQueryPlanners;
        return QueryPerfPrms.tasktab().intAt(key, QueryPerfPrms.tab().intAt(key, 1));
    }

    public static boolean createIndexes() {
        Long key = createIndexes;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, true));
    }

    public static String getDatabaseName() {
        Long key = databaseName;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, DEFAULT_DATABASE_NAME));
    }

    public static String getDatabaseServerHost() {
        Long key = databaseServerHost;
        String host = QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, DEFAULT_DATABASE_SERVER_HOST));
        return HostHelper.isLocalHost((String)host) ? DEFAULT_DATABASE_SERVER_HOST : host;
    }

    public static int getDatabaseServerPort() {
        Long key = databaseServerPort;
        return QueryPerfPrms.tasktab().intAt(key, QueryPerfPrms.tab().intAt(key, 3306));
    }

    public static String getUser() {
        Long key = user;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, DEFAULT_USER));
    }

    public static String getPassword() {
        Long key = password;
        String val = QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, DEFAULT_PASSWORD));
        return val.equalsIgnoreCase("none") ? null : val;
    }

    public static int getEvictionHeapPercentage() {
        Long key = evictionHeapPercentage;
        int val = QueryPerfPrms.tasktab().intAt(key, QueryPerfPrms.tab().intAt(key, 0));
        if (val < 0 || val > 100) {
            String s = BasePrms.nameForKey((Long)key) + " must be between 0 and 100: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static String getDBSynchronizerName() {
        Long key = dbSynchronizerName;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, null));
    }

    public static String getDBSynchronizerConfig() {
        Long key = dbSynchronizerConfig;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, ""));
    }

    public static String getDBSynchronizerServerGroups() {
        Long key = dbSynchronizerServerGroups;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, null));
    }

    public static int getDBAPI() {
        Long key = dbapi;
        String val = QueryPerfPrms.tab().stringAt(key);
        if (val.equalsIgnoreCase("MYSQL")) {
            return 3;
        }
        if (val.equalsIgnoreCase("MYSQLC")) {
            return 4;
        }
        if (val.equalsIgnoreCase("ORACLE")) {
            return 5;
        }
        if (val.equalsIgnoreCase("GPDB")) {
            return 7;
        }
        String s = "Illegal value for " + BasePrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getUpdatePercentage() {
        Long key = updatePercentage;
        return QueryPerfPrms.tasktab().intAt(key, QueryPerfPrms.tab().intAt(key, 0));
    }

    public static int getTxIsolation() {
        Long key = txIsolation;
        String val = QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, "none"));
        return QueryPerfPrms.getTxIsolation(key, val);
    }

    private static int getTxIsolation(Long key, String val) {
        if (val.equalsIgnoreCase("transaction_none") || val.equalsIgnoreCase("transactionNone") || val.equalsIgnoreCase("none")) {
            return 0;
        }
        if (val.equalsIgnoreCase("transaction_read_uncommitted") || val.equalsIgnoreCase("transactionReadUncommitted") || val.equalsIgnoreCase("read_uncommitted") || val.equalsIgnoreCase("readUncommitted")) {
            return 1;
        }
        if (val.equalsIgnoreCase("transaction_read_committed") || val.equalsIgnoreCase("transactionReadCommitted") || val.equalsIgnoreCase("read_committed") || val.equalsIgnoreCase("readCommitted")) {
            return 2;
        }
        if (val.equalsIgnoreCase("transaction_repeatable_read") || val.equalsIgnoreCase("transactionRepeatableRead") || val.equalsIgnoreCase("repeatable_read") || val.equalsIgnoreCase("repeatableRead")) {
            return 4;
        }
        if (val.equalsIgnoreCase("transaction_serializable") || val.equalsIgnoreCase("transactionSerializable") || val.equalsIgnoreCase("serializable")) {
            return 8;
        }
        String s = "Illegal value for " + BasePrms.nameForKey((Long)key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static String getTxIsolation(int n) {
        switch (n) {
            case 0: {
                return "none";
            }
            case 1: {
                return "transaction_read_uncommitted";
            }
            case 2: {
                return "transaction_read_committed";
            }
            case 4: {
                return "transaction_repeatable_read";
            }
            case 8: {
                return "transaction_serializable";
            }
        }
        String s = "Unknown transaction isolation level: " + n;
        throw new QueryPerfException(s);
    }

    public static boolean checkDataLoadEnabled() {
        Long key = checkDataLoadEnabled;
        return QueryPerfPrms.tab().booleanAt(key, true);
    }

    public static List<String> getSizerHints() {
        Long key = sizerHints;
        HydraVector vals = QueryPerfPrms.tasktab().vecAt(key, QueryPerfPrms.tab().vecAt(key, null));
        ArrayList flags = null;
        if (vals != null) {
            flags = new ArrayList();
            flags.addAll(vals);
        }
        return flags;
    }

    public static Map<String, String> getSystemProperties() {
        Long key = systemProperties;
        HydraVector vals = QueryPerfPrms.tasktab().vecAt(key, QueryPerfPrms.tab().vecAt(key, null));
        HashMap<String, String> props = null;
        if (vals != null) {
            props = new HashMap<String, String>();
            for (String val : vals) {
                String[] propval = val.split("=");
                if (propval.length != 2) {
                    String s = BasePrms.nameForKey((Long)key) + " contains a value that is not of the form \"property=value\": " + val;
                    throw new HydraConfigException(s);
                }
                props.put(propval[0], propval[1]);
            }
        }
        return props;
    }

    public static List<String> getTraceFlags() {
        Long key = traceFlags;
        HydraVector vals = QueryPerfPrms.tasktab().vecAt(key, QueryPerfPrms.tab().vecAt(key, null));
        ArrayList flags = null;
        if (vals != null) {
            flags = new ArrayList();
            flags.addAll(vals);
        }
        return flags;
    }

    public static boolean useExistingData() {
        Long key = useExistingData;
        boolean val = QueryPerfPrms.tab().booleanAt(key, false);
        if (val && QueryPrms.getAPI() != 3 && QueryPrms.getAPI() != 4 && QueryPrms.getAPI() != 5 && QueryPrms.getAPI() != 7) {
            String s = " Unsupported query API: " + val;
            throw new HydraConfigException(s);
        }
        return val;
    }

    public static boolean useNetworkLocator() {
        Long key = useNetworkLocator;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, true));
    }

    public static String getKillTarget() {
        Long key = killTarget;
        return QueryPerfPrms.tasktab().stringAt(key, QueryPerfPrms.tab().stringAt(key, null));
    }

    public static boolean isHA() {
        Long key = isHA;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, false));
    }

    public static boolean retryOnXBM09() {
        Long key = retryOnXBM09;
        return QueryPerfPrms.tasktab().booleanAt(key, QueryPerfPrms.tab().booleanAt(key, false));
    }

    public static int getSleepBeforeShutdownSec() {
        Long key = sleepBeforeShutdownSec;
        return QueryPerfPrms.tasktab().intAt(key, QueryPerfPrms.tab().intAt(key, 0));
    }

    public static void main(String[] args) {
        QueryPerfPrms.dumpKeys();
    }

    static {
        QueryPerfPrms.setValues(QueryPerfPrms.class);
    }
}

