/*
 * Decompiled with CFR 0.152.
 */
package cacheperf.comparisons.gemfirexd;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.NanoTimer;
import perffmwk.HistogramStats;
import perffmwk.PerformanceStatistics;

public class QueryPerfStats
extends PerformanceStatistics {
    private static final int SCOPE = 0;
    public static final String VM_COUNT = "vmCount";
    protected static final String PREPARES = "prepares";
    protected static final String PREPARE_TIME = "prepareTime";
    protected static final String QUERIES = "queries";
    protected static final String QUERY_TIME = "queryTime";
    protected static final String CREATES = "creates";
    protected static final String CREATE_TIME = "createTime";
    protected static final String UPDATES = "updates";
    protected static final String UPDATE_TIME = "updateTime";
    protected static final String COMMITS = "commits";
    protected static final String COMMIT_TIME = "commitTime";
    protected static final String ORMS = "ORMs";
    protected static final String ORM_TIME = "ORMTime";
    protected static final String RESULTS = "results";
    protected static final String EMPTY_TABLE_MEM_USE = "emptyTableMemUse";
    protected static final String LOADED_TABLE_MEM_USE = "loadedTableMemUse";
    protected static final String TABLE_MEM_USE = "tableMemUse";
    private static boolean VMCounted = false;

    public static StatisticDescriptor[] getStatisticDescriptors() {
        boolean largerIsBetter = true;
        return new StatisticDescriptor[]{QueryPerfStats.factory().createIntGauge(VM_COUNT, "When aggregated, the number of VMs using this statistics object.", "VMs"), QueryPerfStats.factory().createIntCounter(CREATES, "Number of creates completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(CREATE_TIME, "Total time spent performing creates.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(PREPARES, "Number of statements prepared.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(PREPARE_TIME, "Total time spent preparing statements.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(QUERIES, "Number of queries completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(QUERY_TIME, "Total time spent performing queries.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(UPDATES, "Number of updates completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(UPDATE_TIME, "Total time spent performing updates.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(COMMITS, "Number of statements committed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(COMMIT_TIME, "Total time spent committing.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(ORMS, "Number of ORMs completed.", "operations", largerIsBetter), QueryPerfStats.factory().createLongCounter(ORM_TIME, "Total time spent performing ORMs.", "nanoseconds", !largerIsBetter), QueryPerfStats.factory().createIntCounter(RESULTS, "Result set size.", "rows", largerIsBetter), QueryPerfStats.factory().createLongGauge(EMPTY_TABLE_MEM_USE, "Memory used when tables are empty.", "bytes", !largerIsBetter), QueryPerfStats.factory().createLongGauge(LOADED_TABLE_MEM_USE, "Memory used when table data is loaded", "bytes", !largerIsBetter), QueryPerfStats.factory().createLongGauge(TABLE_MEM_USE, "Memory used by table data", "bytes", !largerIsBetter)};
    }

    public static QueryPerfStats getInstance() {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0);
        qps.incVMCount();
        return qps;
    }

    public static QueryPerfStats getInstance(String name) {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0, (String)name);
        qps.incVMCount();
        return qps;
    }

    public static QueryPerfStats getInstance(String name, String trimspecName) {
        QueryPerfStats qps = (QueryPerfStats)QueryPerfStats.getInstance(QueryPerfStats.class, (int)0, (String)name, (String)trimspecName);
        qps.incVMCount();
        return qps;
    }

    public QueryPerfStats(Class cls, StatisticsType type, int scope, String instanceName, String trimspecName) {
        super(cls, type, scope, instanceName, trimspecName);
    }

    public int getCreates() {
        return this.statistics().getInt(CREATES);
    }

    public long getCREATETime() {
        return this.statistics().getLong(CREATE_TIME);
    }

    public int getPrepares() {
        return this.statistics().getInt(PREPARES);
    }

    public long getPrepareTime() {
        return this.statistics().getLong(PREPARE_TIME);
    }

    public int getQueries() {
        return this.statistics().getInt(QUERIES);
    }

    public long getQUERYTime() {
        return this.statistics().getLong(QUERY_TIME);
    }

    public int getUpdates() {
        return this.statistics().getInt(UPDATES);
    }

    public long getUPDATETime() {
        return this.statistics().getLong(UPDATE_TIME);
    }

    public int getCommits() {
        return this.statistics().getInt(COMMITS);
    }

    public long getCommitTime() {
        return this.statistics().getLong(COMMIT_TIME);
    }

    public int getORMs() {
        return this.statistics().getInt(ORMS);
    }

    public long getORMTime() {
        return this.statistics().getLong(ORM_TIME);
    }

    public long getEmptyTableMemUse() {
        return this.statistics().getLong(EMPTY_TABLE_MEM_USE);
    }

    public long getLoadedTableMemUse() {
        return this.statistics().getLong(LOADED_TABLE_MEM_USE);
    }

    public long getTableMemUse() {
        return this.statistics().getLong(TABLE_MEM_USE);
    }

    public void incHistogram(HistogramStats histogram, long amount) {
        if (histogram != null) {
            histogram.incBin(amount);
        }
    }

    private synchronized void incVMCount() {
        if (!VMCounted) {
            this.statistics().incInt(VM_COUNT, 1);
            VMCounted = true;
        }
    }

    public void incCreates() {
        this.incCreates(1);
    }

    public void incCreates(int amount) {
        this.statistics().incInt(CREATES, amount);
    }

    public void incCreateTime(long amount) {
        this.statistics().incLong(CREATE_TIME, amount);
    }

    public long startCreate() {
        return NanoTimer.getTime();
    }

    public void endCreate(long start, HistogramStats histogram) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(CREATES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(CREATE_TIME, elapsed);
        this.incHistogram(histogram, elapsed);
    }

    public void endCreate(long start, int amount, HistogramStats histogram) {
        long elapsed = NanoTimer.getTime() - start;
        this.incCreates(amount);
        this.incCreateTime(elapsed);
        this.incHistogram(histogram, elapsed);
    }

    public void incPrepares() {
        this.incPrepares(1);
    }

    public void incPrepares(int amount) {
        this.statistics().incInt(PREPARES, amount);
    }

    public void incPrepareTime(long amount) {
        this.statistics().incLong(PREPARE_TIME, amount);
    }

    public long startPrepare() {
        return NanoTimer.getTime();
    }

    public void endPrepare(long start, HistogramStats histogram) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(PREPARES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(PREPARE_TIME, elapsed);
        this.incHistogram(histogram, elapsed);
    }

    public void incQueries() {
        this.incQueries(1);
    }

    public void incQueries(int amount) {
        this.statistics().incInt(QUERIES, amount);
    }

    public void incQueryTime(long amount) {
        this.statistics().incLong(QUERY_TIME, amount);
    }

    public long startQuery() {
        return NanoTimer.getTime();
    }

    public void endQuery(long start, HistogramStats histogram) {
        this.endQuery(start, 0, histogram);
    }

    public void endQuery(long start, int results, HistogramStats histogram) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(QUERIES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(QUERY_TIME, elapsed);
        if (results > 0) {
            this.statistics().incInt(RESULTS, results);
        }
        this.incHistogram(histogram, elapsed);
    }

    public void incUpdates() {
        this.incUpdates(1);
    }

    public void incUpdates(int amount) {
        this.statistics().incInt(UPDATES, amount);
    }

    public void incUpdateTime(long amount) {
        this.statistics().incLong(UPDATE_TIME, amount);
    }

    public long startUpdate() {
        return NanoTimer.getTime();
    }

    public void endUpdate(long start, HistogramStats histogram) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(UPDATES, 1);
        long elapsed = ts - start;
        this.statistics().incLong(UPDATE_TIME, elapsed);
        this.incHistogram(histogram, elapsed);
    }

    public void incCommits() {
        this.incCommits(1);
    }

    public void incCommits(int amount) {
        this.statistics().incInt(COMMITS, amount);
    }

    public void incCommitTime(long amount) {
        this.statistics().incLong(COMMIT_TIME, amount);
    }

    public long startCommit() {
        return NanoTimer.getTime();
    }

    public void endCommit(long start) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(COMMITS, 1);
        long elapsed = ts - start;
        this.statistics().incLong(COMMIT_TIME, elapsed);
    }

    public void incORMs() {
        this.incORMs(1);
    }

    public void incORMs(int amount) {
        this.statistics().incInt(ORMS, amount);
    }

    public void incORMTime(long amount) {
        this.statistics().incLong(ORM_TIME, amount);
    }

    public long startORM() {
        return NanoTimer.getTime();
    }

    public void endORM(long start, HistogramStats histogram) {
        long ts = NanoTimer.getTime();
        this.statistics().incInt(ORMS, 1);
        long elapsed = ts - start;
        this.statistics().incLong(ORM_TIME, elapsed);
        this.incHistogram(histogram, elapsed);
    }

    public void setEmptyTableMemUse(long emptyTableMemUse) {
        this.statistics().setLong(EMPTY_TABLE_MEM_USE, emptyTableMemUse);
    }

    public void setLoadedTableMemUse(long loadedTableMemUse) {
        long emptyTableMemUse = this.statistics().getLong(EMPTY_TABLE_MEM_USE);
        this.statistics().setLong(LOADED_TABLE_MEM_USE, loadedTableMemUse);
        this.statistics().setLong(TABLE_MEM_USE, loadedTableMemUse - emptyTableMemUse);
    }
}

